<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>

<db:script src="/database/dbclone/remoteSelector.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="customizeDestOptionsPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_AdvDestOptions"/>
        <uix:formValue name="lovName"/>
        <uix:formValue name="fetchType"/>
        
        <uix:pageLayout titleBinding="CUSTOMIZE_DESTINATION_OPTION_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>

          <uix:separator/>
            
          <uix:switcher childNameBinding="useOMFFlag@dbCloneBean@servletRequest">
            <uix:case name="false">
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:styledText 	styleClass="OraInstructionText"
                      textBinding="CUSTOMIZE_INSTRUCTION@dbCloneBundle@servletRequest"/>
                  </uix:rowLayout>
                  <%@ include file="/database/dbclone/advDestOptions.jspf" %>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
            <uix:case name="true">
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:styledText 	styleClass="OraInstructionText"
                      textBinding="CUSTOMIZE_INSTRUCTION_OMF@dbCloneBundle@servletRequest"/>
                  </uix:rowLayout>
                  <%@ include file="/database/dbclone/omfLocations.jspf" %>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                name="event" value="cancelCustomize" shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"/> 
              <uix:submitButton textBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                name="event" value="applyCustomize" shortDescBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
