<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="customizeDestAsmPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_AdvDestOptions"/>
        
        <uix:pageLayout titleBinding="CUSTOMIZE_DESTINATION_OPTION_HEADER_ASM@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>

          <uix:separator/>
          
          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout>
                <uix:styledText 	styleClass="OraInstructionText"
                  textBinding="CUSTOMIZE_INSTRUCTION_ASM@convertBundle@servletRequest"/>
              </uix:rowLayout>
              <%@ include file="/database/convert/advDestOptions.jspf" %>
            </uix:contents>
          </uix:stackLayout>
            
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                name="event" value="cancelCustomizeConvert" shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"/> 
              <uix:submitButton textBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                name="event" value="applyCustomizeConvert" shortDescBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
