<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/dbclone/remoteSelector.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="archivingModePageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_ArchivingMode"/>
        <uix:formValue name="lovName"/>
        <uix:formValue name="fetchType"/>
        
        <uix:pageLayout titleBinding="ARCHIVING_MODE_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="."/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <%--
          <uix:pageStatus>
            <uix:tableLayout width="100%" summary="tl"> 
              <uix:contents>
                <uix:rowLayout>
                  <uix:formattedText styleClass="OraInstructionText" 
                    textBinding="archivingInstruction@dbCloneBean@servletRequest"/>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          </uix:pageStatus>

          <uix:labeledFieldLayout width="75%">
            <uix:styledText styleClass="OraInstructionText" 
              textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="srcDbName@dbCloneBean@servletRequest"/>
            <uix:styledText styleClass="OraInstructionText"
              textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="srcHostName@dbCloneBean@servletRequest"/>
          </uix:labeledFieldLayout>	

          <uix:separator/>
          --%>

          <uix:pageStatus>
            <uix:labeledFieldLayout width="100%">
              <uix:styledText styleClass="OraInstructionText" 
                textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
              <uix:styledText styleClass="OraInstructionTextStrong" 
                textBinding="srcDbName@dbCloneBean@servletRequest"/>
              <uix:styledText styleClass="OraInstructionText"
                textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
              <uix:styledText styleClass="OraInstructionTextStrong" 
                textBinding="srcHostName@dbCloneBean@servletRequest"/>
            </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>

          <uix:rowLayout>
            <uix:formattedText styleClass="OraInstructionTextStrong" 
              textBinding="archivingInstruction@dbCloneBean@servletRequest"/>
          </uix:rowLayout>
          <uix:spacer height="5" />
          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" 
              textBinding="ARCHIVING_MODE_INSTRUCTION@dbCloneBundle@servletRequest"/>
          </uix:rowLayout>
          
          <%--....................... Start of included section .......................--%>
          <uix:stackLayout>
            <uix:contents>
              <%@ include file="/database/dbclone/archivingMode.jspf" %>
            </uix:contents>
          </uix:stackLayout>
          <%--................... End of included section .............................--%>
	
          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
              <uix:navigationBar 
                name="dbCloneNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="dbCloneForm"
                maxValueBinding="maxNavValue@dbCloneBean@servletRequest"
                minValue="1"
                valueBinding="navValue@dbCloneBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
