<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="asmPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_StartingPage"/>

        <uix:pageLayout titleBinding="ASM_PAGE_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>
          
          <%-- Error message --%>
          <%@ include file="/database/convert/errors.jspf" %>
          
          <%-- context info --%>
          <uix:pageStatus>
            <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
              <uix:case name="false">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcDbName@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="DESTINATION_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="destHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>	
              </uix:case>
              <uix:case name="true">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_BACKUP_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="existingSrcBsLocation@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="DESTINATION_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="destHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>	
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>

          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout>
                <uix:formattedText styleClass="OraInstructionText"
                  textBinding="asmPageInstruction@dbCloneBean@servletRequest"/>
              </uix:rowLayout>
              <%@ include file="/database/convert/startingPage.jspf" %>
            </uix:contents>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="asmPageNoLabel@dbCloneBean@servletRequest" 
                name="event" value="asmNo" shortDescBinding="asmPageNoLabel@dbCloneBean@servletRequest"/> 
              <uix:submitButton name ="event"
                textBinding="asmPageYesLabel@dbCloneBean@servletRequest"
                value="asmYes" shortDescBinding="asmPageYesLabel@dbCloneBean@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>
          
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
