<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="submitConfirmPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_Confirm"/>

        <uix:pageLayout titleBinding="SUBMIT_CONFIRMATION_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <uix:stackLayout>
            <uix:contents>

              <oem:messageBox messageType="error"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" 
                mainTextKey="mainText" />

              <oem:messageBox messageType="info"
                errorTableBinding="confirmation@servletRequest"
                titleTextKey="titleText" 
                mainTextKey="mainText" />

            </uix:contents>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="VIEW_STATUS_BUTTON_TEXT@dbCloneBundle@servletRequest"
               shortDescBinding="VIEW_STATUS_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="jobsTableURL@dbCloneBean@servletRequest" />
              <uix:button textBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest"
               shortDescBinding="OK_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
