<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="multiplexLogsPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_MultiplexLocations"/>
        
        <uix:pageLayout titleBinding="MULTIPLEX_REDOLOGS_CONTROLFILES_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>

          <uix:separator/>

          <%--...... Start of included section .............--%>
          <uix:switcher childNameBinding="convertASMFlag@dbCloneBean@servletRequest">
            <uix:case name="false">
              <%@ include file="/database/dbclone/multiplexLocationsOmf.jspf" %>
            </uix:case>
            <uix:case name="true">
              <%@ include file="/database/convert/multiplexLocations.jspf" %>
            </uix:case>
          </uix:switcher>
          <%--...... End of included section ...............--%>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="cancelMultiplex" shortDescBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest"/> 
              <uix:submitButton textBinding="OK_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="applyMultiplex" shortDescBinding="OK_BUTTON_TEXT@convertBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
