<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext" ><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="processingPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">        
          <uix:formValue name="pageName" value="/database/dbclone/dbClone_processing"/>

          <uix:pageLayout>

            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                textBinding="PROCESSING_HEADER@dbCloneBundle@servletRequest"
                icon="/em/images/processl.gif">

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="PROCESSING_INSTRUCTION@dbCloneBundle@servletRequest"/>
                  </uix:flowLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            timeInterval="processingInterval@dbCloneBean@servletRequest">
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="5%">
                              <uix:contents>
                                <uix:image
                                    sourceBinding="step0Image@dbCloneBean@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                    shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                    destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
