<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="viewLogsPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_RedologsControlfiles"/>
        
        <uix:pageLayout titleBinding="VIEW_REDOLOGS_CONTROLFILES_HEADER@convertBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>

          <uix:separator/>

          <uix:tableLayout width="100%" summary="tl"> 
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="VIEW_REDOLOGS_CONTROLFILES_INSTRUCTION@dbCloneBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:tableLayout>
          
          <%--...... Start of included section .............--%>
          <%@ include file="/database/convert/redologsControlfiles.jspf" %>
          <%--...... End of included section ...............--%>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="RETURN_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="finishViewRedologsControlfiles" shortDescBinding="RETURN_BUTTON_TEXT@convertBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
