<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
  
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="reviewPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
       <uix:formValue name="pageName" value="/database/dbclone/dbClone_Review"/>
        
        <uix:pageLayout titleBinding="REVIEW_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="."/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
              <uix:case name="false">
                <uix:formattedText styleClass="OraInstructionText" textBinding="reviewOverviewNewBS@dbCloneBean@servletRequest"/>
              </uix:case>
              <uix:case name="true">
                <uix:formattedText styleClass="OraInstructionText" textBinding="reviewOverviewExistingBS@dbCloneBean@servletRequest"/>
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>

          <uix:spacer height="10" />

          <%-- Job name and scheduling --%>
          <uix:labeledFieldLayout labelWidth="40%">
            <uix:messagePrompt promptBinding="JOB_NAME@dbCloneBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="jobName@dbCloneBean@servletRequest"/>
            <uix:messageStyledText promptBinding="DESCRIPTION_PROMPT@dbCloneBundle@servletRequest"
              styleClass="OraInstructionTextStrong" textBinding="jobDescription@dbCloneBean@servletRequest"
              renderedBinding="jobDescriptionProvided@dbCloneBean@servletRequest"/> 
            <uix:messagePrompt promptBinding="JOB_SCHEDULE@dbCloneBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="jobSchedule@dbCloneBean@servletRequest"/>
			
			<uix:messagePrompt promptBinding="SOURCE_TYPE@dbCloneBundle@servletRequest"/>
			<uix:switcher childNameBinding="bsUsage@dbCloneBean@servletRequest">
			  <uix:case name="NEW_BS">				
			    <uix:styledText styleClass="OraInstructionTextStrong" 
					  textBinding="NEW_BACKUP_SET_PROMPT@dbCloneBundle@servletRequest"/>
			  </uix:case>
			  <uix:case name="EXISTING_BS">
			    <uix:tableLayout summary="tl"> 
					<uix:contents>
						<uix:switcher childNameBinding="backupType@dbCloneBean@servletRequest">
						 <uix:case name="BS_RMAN">
							<uix:styledText styleClass="OraInstructionTextStrong" 
								textBinding="RMAN_FULL_DB_PROMPT@dbCloneBundle@servletRequest"/>
						 </uix:case>

						 <uix:case name="BS_SAVED">
							<uix:styledText styleClass="OraInstructionTextStrong" 
								textBinding="EXISTING_BACKUP_SET_PROMPT@dbCloneBundle@servletRequest"/>
						 </uix:case>

						</uix:switcher>
					</uix:contents>
				</uix:tableLayout>			    
			  </uix:case>
			</uix:switcher>
          </uix:labeledFieldLayout>

          <%--.................. Details ........................--%>
          <uix:header textBinding="DETAILS_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>
            
          <uix:tableLayout width="100%" cellSpacing="2" summary="tl">           
            <uix:rowLayout vAlign="top">
	
          <%-- Source database or backup files related options --%>
          <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
            <uix:case name="false">
              <uix:header textBinding="REVIEW_SOURCE_HEADER@dbCloneBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="sourceDBName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcSID@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DB_VERSION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="compatibleDbVersion@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcOracleHome@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSType@dbCloneBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSVersion@dbCloneBean@servletRequest"/>
                    </uix:flowLayout>
                    <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostUserName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DATABASE_USERNAME@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcDBUsrname@dbCloneBean@servletRequest"/>                    

                    <%-- Hide 'RMAN Backup Location' when RMAN Backup is not in operation  --%>
                    <uix:switcher childNameBinding="isExistingRMANBackup@dbCloneBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" textBinding="rmanWorkingLoc@dbCloneBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="isExistingRMANBackup@dbCloneBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="RMAN_BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" textBinding="srcBsLocation@dbCloneBean@servletRequest"/>						
                      </uix:case>
                      <uix:case name="false">
                        <uix:messageStyledText promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" textBinding="srcBsLocation@dbCloneBean@servletRequest"/>                        
                      </uix:case>
                    </uix:switcher>

                    <uix:messagePrompt promptBinding="DATABASE_REGISTER_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcDbName@dbCloneBean@servletRequest"/>
										
                    <%-- Hide 'Retain Working Directory' & 'Compress backup files' when RMAN Backup is not in operation  --%>
                    <uix:switcher childNameBinding="isNewBackupStaging@dbCloneBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="RETAIN_WORKING_DIRECTORY@dbCloneBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" textBinding="retainWorkingDir@dbCloneBean@servletRequest"/>						
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="isNewBackupStaging@dbCloneBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="COMPRESS_BACKUP_FILES_FOR_REVIEW@dbCloneBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" textBinding="compressBackupFilesForUI@dbCloneBean@servletRequest"
                          renderedBinding="is10gOrHigher@dbCloneBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>

                    <uix:messagePrompt promptBinding="MODE_PROMPT@dbCloneBundle@servletRequest"/>
                              <uix:styledText styleClass="OraInstructionTextStrong" 
                                textBinding="srcDbMode@dbCloneBean@servletRequest"/>					
					
                    <%-- Hide 'Backup Type' when RMAN Backup is not in operation  --%>
                    <uix:switcher childNameBinding="isExistingRMANBackup@dbCloneBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="BACKUP_TYPE@dbCloneBundle@servletRequest"
                                  styleClass="OraInstructionTextStrong" textBinding="rmanBackupType@dbCloneBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>

                    <uix:messageStyledText promptBinding="RESTART_DATABASE_INSTANCE@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="restartDBValue@dbCloneBean@servletRequest"
                      renderedBinding="restartDB@dbCloneBean@servletRequest"/> 

                    <uix:messageStyledText promptBinding="SWITCH_ARCHIVING_MODE@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="switchArchivingModeValue@dbCloneBean@servletRequest"
                      renderedBinding="restartDB@dbCloneBean@servletRequest"/> 

                    <uix:messageStyledText promptBinding="ARCHIVEDLOG_DIR_PROMPT@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="archDir@dbCloneBean@servletRequest"
                      renderedBinding="switchArchivingMode@dbCloneBean@servletRequest"/> 

                    <uix:messageStyledText promptBinding="INIT_ORA_DIR_PROMPT@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="srcPfile@dbCloneBean@servletRequest"
                      renderedBinding="pfileUsedForSwitchingArchMode@dbCloneBean@servletRequest"/> 
                  
                  </uix:labeledFieldLayout>
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
            <uix:case name="true">
              <uix:header textBinding="SOURCE_BACKUP_PROMPT@dbCloneBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="sourceDBName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcSID@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DB_VERSION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="compatibleDbVersion@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcOracleHome@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSType@dbCloneBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSVersion@dbCloneBean@servletRequest"/>
                    </uix:flowLayout>
                    <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostUserName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcBsLocation@dbCloneBean@servletRequest"/>
                  </uix:labeledFieldLayout>	
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>

          <%-- Destination Oracle Home related options --%>
          <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
            <uix:case name="false">
              <uix:header textBinding="REVIEW_DESTINATION_HEADER@dbCloneBundle@servletRequest">
                <uix:contents>

                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destGlobalDbName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destSid@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="COL_ORACLE_SERVER_VER@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destHomeVersion@dbCloneBean@servletRequest"/>
                    <uix:messageStyledText promptBinding="oracleBaseLabel@dbCloneBean@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="oracleBase@dbCloneBean@servletRequest"
                      renderedBinding="showOracleBase@dbCloneBean@servletRequest"/> 
                    <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destOracleHome@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>      
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destHostName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destOSType@dbCloneBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destOSVersion@dbCloneBean@servletRequest"/>
                    </uix:flowLayout>
                    <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destHostUserName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DATABASE_USERNAME@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcDBUsrname@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destBsLocation@dbCloneBean@servletRequest"/>
					<uix:messagePrompt promptBinding="TRANSFER_FILE_MECHANISM@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="fileTransferMechanism@dbCloneBean@servletRequest"/>
                      
                    <uix:messageStyledText promptBinding="DATABASE_REGISTER_PROMPT@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="registerDBName@dbCloneBean@servletRequest"
                      renderedBinding="registerDatabase@dbCloneBean@servletRequest"/> 

                    <uix:messagePrompt promptBinding="NETWORK_CONFIG_FILES_LOCATION_LABEL@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="netConfigFileLocation@dbCloneBean@servletRequest"/>
                      
                    <uix:messagePrompt promptBinding="DEST_DB_STORAGE@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="storageTypeForReview@dbCloneBean@servletRequest"/> 

                    <uix:messageStyledText promptBinding="CUSTOMER_SCRIPT_HEADER@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="customerScriptForReview@dbCloneBean@servletRequest"
                      renderedBinding="isCustomerScriptFromFile@dbCloneBean@servletRequest"/>

                    <uix:messageStyledText promptBinding="CUSTOMER_SCRIPT_HEADER@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="REVIEW_POST_CLONE_SCRIPT_PROMPT@dbCloneBundle@servletRequest"
                      renderedBinding="isCustomerScriptUserEntered@dbCloneBean@servletRequest"/>

                    <uix:messageStyledText promptBinding="MASK_SCRIPT_HEADER@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="maskScriptForReview@dbCloneBean@servletRequest" />

                    <uix:messageStyledText promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="asmInstance@convertBean@servletRequest"
                      renderedBinding="convertASM@dbCloneBean@servletRequest"/>
              
                  </uix:labeledFieldLayout>	
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
            <uix:case name="true"> 
              <uix:header textBinding="REVIEW_DESTINATION_HEADER@dbCloneBundle@servletRequest">
                <uix:contents>

                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destGlobalDbName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destSid@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="COL_ORACLE_SERVER_VER@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destHomeVersion@dbCloneBean@servletRequest"/>
                    <uix:messageStyledText promptBinding="oracleBaseLabel@dbCloneBean@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="oracleBase@dbCloneBean@servletRequest"
                      renderedBinding="showOracleBase@dbCloneBean@servletRequest"/> 
                    <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destOracleHome@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>      
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destHostName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destOSType@dbCloneBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destOSVersion@dbCloneBean@servletRequest"/>
                    </uix:flowLayout>
                    <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="destHostUserName@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="destBsLocation@dbCloneBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="TRANSFER_FILE_MECHANISM@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="fileTransferMechanism@dbCloneBean@servletRequest"/>
                    
                    <uix:messageStyledText promptBinding="DATABASE_REGISTER_PROMPT@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="registerDBName@dbCloneBean@servletRequest"
                      renderedBinding="registerDatabase@dbCloneBean@servletRequest"/> 

                    <uix:messagePrompt promptBinding="NETWORK_CONFIG_FILES_LOCATION_LABEL@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="netConfigFileLocation@dbCloneBean@servletRequest"/>
                      
                    <uix:messagePrompt promptBinding="DEST_DB_STORAGE@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="storageTypeForReview@dbCloneBean@servletRequest"/>
                      
                    <uix:messageStyledText promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="asmInstance@convertBean@servletRequest"
                      renderedBinding="convertASM@dbCloneBean@servletRequest"/>
              
                  </uix:labeledFieldLayout>	
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>

            </uix:rowLayout>                
          </uix:tableLayout> 

          <uix:hideShowHeader disclosedBinding="showDatabaseFiles@dbCloneBean@servletRequest"
            formSubmitted="true" id="hideShow"
            textBinding="databaseFileLocationsHeaderForReview@dbCloneBean@servletRequest">
            <uix:contents>
    
              <uix:stackLayout>
                <uix:contents>
                
                  <uix:switcher childNameBinding="showOMFSpecForReview@dbCloneBean@servletRequest">
                    <uix:case name="false">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:formattedText styleClass="OraInstructionText" textBinding="databaseFileLocationsInstructionReview@dbCloneBean@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="left" width="80%" headers=""> 
                            <uix:formattedText styleClass="OraInstructionText" textBinding="databaseFileLocationsInstructionReview@dbCloneBean@servletRequest"/>
                          </uix:cellFormat>
                          <uix:cellFormat vAlign="top" hAlign="right" width="20%" headers=""> 
                            <uix:submitButton name="event" value="viewSourceDatabaseFiles" 
                              textBinding="viewDatabaseFilesButtonText@dbCloneBean@servletRequest"
                              shortDescBinding="viewDatabaseFilesButtonText@dbCloneBean@servletRequest"
                            />
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  
                  <uix:spacer height="10" />
                  
                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messageStyledText promptBinding="DATABASE_AREA_LOC@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="databaseAreaForReview@dbCloneBean@servletRequest"
                      renderedBinding="showOMFSpecForReview@dbCloneBean@servletRequest"/> 
                    <uix:messageStyledText promptBinding="RECOVERY_AREA_LOC@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="recoveryAreaForReview@dbCloneBean@servletRequest"
                      renderedBinding="showRecoveryAreaSpecForReview@dbCloneBean@servletRequest"/> 
                    <uix:messageStyledText promptBinding="RECOVERY_AREA_SIZE@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="recoveryAreaSizeForReview@dbCloneBean@servletRequest"
                      renderedBinding="showRecoveryAreaSpecForReview@dbCloneBean@servletRequest"/> 
                    <uix:messageStyledText promptBinding="MULTIPLEX_LOG_CTL_FILES@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="multiplexLocationsForReview@dbCloneBean@servletRequest"
                      renderedBinding="showOMFSpecForReview@dbCloneBean@servletRequest"/> 
                  </uix:labeledFieldLayout>
                  
                  <uix:header textBinding="dataFilesHeaderForReview@dbCloneBean@servletRequest"
                    renderedBinding="showDataFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewDatafileListTable"
			summaryBinding="dataFilesHeaderForReview@dbCloneBean@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewDatafileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="TEMPFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showTempfilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewTempfileListTable"
			summaryBinding="TEMPFILES_HEADER@dbCloneBundle@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewTempfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="LOGFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showLogFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewLogfileListTable"
			summaryBinding="LOGFILES_HEADER@dbCloneBundle@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewLogfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="CONTROLFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showControlFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewControlfileListTable"
			summaryBinding="CONTROLFILES_HEADER@dbCloneBundle@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewControlfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <%--  Display Archived Log Locations table only in "Files System & OFA" case    --%>
                  <uix:header textBinding="ARCHIVED_LOG_HEADER@dbCloneBundle@servletRequest" 
                     renderedBinding="showArchivedLogDestTable@dbCloneBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%"
                            blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                            name="reviewArchivedLogsTable"
                            summaryBinding="ARCHIVED_LOG_HEADER@dbCloneBundle@servletRequest"
                            beanKey="dbCloneBean"
                            formSubmitted="true"
                            dataSourceProp="reviewArchivedLogsTable"
                            copyParams="target,type,cancelURL,oname"/>  
                      </uix:contents>
                  </uix:header>
                  <uix:header textBinding="DIR_OBJ_HEADER@dbCloneBundle@servletRequest">
                    <uix:contents>
                      <oem:table width="80%" blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewDirectoryObjListTable"
			summaryBinding="DIR_OBJ_HEADER@dbCloneBundle@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewDirectoryObjListTable"
                        copyParams="target,type,cancelURL,oname"/>
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="EXTERNAL_FILE_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="is9iOrHigher@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%" blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewExternalFileListTable"
			summaryBinding="EXTERNAL_FILE_HEADER@dbCloneBundle@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewExternalFileListTable"
                        copyParams="target,type,cancelURL,oname"/>
                    </uix:contents>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>

            </uix:contents>
          </uix:hideShowHeader>

            </uix:contents>	
          </uix:header>


          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
              <uix:navigationBar name="dbCloneNavBar"
                blockSize="-1"
                formSubmitted="true"
                maxValueBinding="maxNavValue@dbCloneBean@servletRequest"
                minValue="1"
                valueBinding="navValue@dbCloneBean@servletRequest"/>
              <uix:submitButton name ="event" 
                value="submitCloneJob"
                textBinding="SUBMIT_BUTTON_TEXT@dbCloneBundle@servletRequest" shortDescBinding="SUBMIT_BUTTON_TEXT@dbCloneBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
