<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="schedulePageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
       
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_Schedule"/>
        
        <uix:pageLayout titleBinding="SCHEDULE_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
            <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
              <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <%-- context info --%>
          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>

          <uix:tableLayout width="100%" summary="tl"> 
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="SCHEDULE_INSTRUCTION@dbCloneBundle@servletRequest"/>
              </uix:rowLayout>
          </uix:tableLayout>

          <%--.................. job ...................--%>	
          <uix:header textBinding="JOB_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>

              <uix:labeledFieldLayout labelWidth="15%">
                <uix:contents>
                  <uix:messageTextInput id="jobName"
                    name="jobName"
                    promptBinding="JOB_NAME_PROMPT@dbCloneBundle@servletRequest"
                    textBinding="jobName@dbCloneBean@servletRequest"
                    columns="60" 
                    messageBinding="(JOB_NAME_PROMPT@dbCloneBundle@servletRequest)@messages@servletRequest"
                    messageTypeBinding="(JOB_NAME_PROMPT@dbCloneBundle@servletRequest)@messageTypes@servletRequest"
                    required="uiOnly"/>
                  <uix:messagePrompt labeledNodeId="jobDescription" promptBinding="DESCRIPTION_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:textInput id="jobDescription" name="jobDescription"
                    textBinding="jobDescription@dbCloneBean@servletRequest"
                    columns="60" />
                </uix:contents>
              </uix:labeledFieldLayout>

            </uix:contents>
          </uix:header>
             
          <%--...................... schedule .......................--%>
          <%@ include file="/sdk/schedule/start.jspf"%>
          
          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
              <uix:navigationBar 
                name="dbCloneNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="dbCloneForm"
                maxValueBinding="maxNavValue@dbCloneBean@servletRequest"
                minValue="1"
                valueBinding="navValue@dbCloneBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
