<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf"%>

<% 
boolean _isClone = true;
%>

<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.indexOf('".')) > 0)
  {
    if(destField == "selectedHostOH")
    {
      document.forms[0].selectedHostOH.value=data.substring(1,i);
      s = data.substring(i+3, data.length-1);
      document.forms[0].hostOH.value=s;
    }
  }
}
</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext" /> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="selectDestPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
    
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_SelectDest"/>
        <uix:formValue name="lovDatabaseVersionForHA" valueBinding="lovDatabaseVersionForHA@dbCloneBean@servletRequest"/>
        <uix:formValue name="lovOSType" valueBinding="lovOSType@dbCloneBean@servletRequest"/>
        <uix:formValue name="lovSrcHostName" valueBinding="lovSrcHostName@dbCloneBean@servletRequest"/> 
        <uix:formValue name="lovSrcOracleHome" valueBinding="lovSrcOracleHome@dbCloneBean@servletRequest"/>
        <uix:formValue name="lovCompatibleDbVersion" valueBinding="lovCompatibleDbVersion@dbCloneBean@servletRequest"/>
        <uix:formValue name="lovCompatibleOSType" valueBinding="lovCompatibleOSType@dbCloneBean@servletRequest"/> 
        <uix:formValue name="lovCompatibleOSVersion" valueBinding="lovCompatibleOSVersion@dbCloneBean@servletRequest"/> 
        <uix:pageLayout titleBinding="SELECT_DESTINATION_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <%-- Wizard train --%>
          <uix:location>
            <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
              <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <%-- context info --%>
          <uix:pageStatus>
            <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
              <uix:case name="false">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcDbName@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>	
              </uix:case>
              <uix:case name="true">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_BACKUP_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="existingSrcBsLocation@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>	
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>
          
          <uix:header textBinding="SELECT_ORACLE_HOME_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>

              <%-- Start of included section --%>	  
              <uix:stackLayout>
                <uix:contents>
                  <%@ include file="/database/dbclone/selectDest.jspf" %>
                </uix:contents>
              </uix:stackLayout>
              <%-- End of included section --%>

            </uix:contents>
          </uix:header>
         
          <uix:header textBinding="DEST_HOST_CREDENTIAL_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>
              <uix:tableLayout width="100%" summary="tl"> 
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="DEST_HOST_CREDENTIAL_INSTRUCTION@dbCloneBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <%@ include file="/credentials.jspf" %>
	    </uix:contents>
          </uix:header>
          
          <%-- destination global DB name and sid --%>
          <uix:header textBinding="DEST_DB_NAME_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>
              
              <uix:labeledFieldLayout labelWidth="30%">
                <uix:messageTextInput id="destGlobalDbName"
                  name="destGlobalDbName"
                  promptBinding="DESTINATION_GLOBAL_NAME_PROMPT@dbCloneBundle@servletRequest"
                  textBinding="destGlobalDbName@dbCloneBean@servletRequest" 
                  tipBinding="DESTINATION_GLOBAL_NAME_TIP@dbCloneBundle@servletRequest"
                  columns="40" 
                  messageBinding="(DESTINATION_GLOBAL_NAME_PROMPT@dbCloneBundle@servletRequest)@messages@servletRequest"
                  messageTypeBinding="(DESTINATION_GLOBAL_NAME_PROMPT@dbCloneBundle@servletRequest)@messageTypes@servletRequest"
                  required="uiOnly"/>
                <uix:messageTextInput id="destSid"
                  name="destSid"
                  promptBinding="DESTINATION_SID_PROMPT@dbCloneBundle@servletRequest"
                  textBinding="destSid@dbCloneBean@servletRequest" 
                  columns="40" 
                  messageBinding="(DESTINATION_SID_PROMPT@dbCloneBundle@servletRequest)@messages@servletRequest"
                  messageTypeBinding="(DESTINATION_SID_PROMPT@dbCloneBundle@servletRequest)@messageTypes@servletRequest"
                  required="uiOnly"/>
                <uix:messagePrompt labeledNodeId="storageType" 
                  promptBinding="DEST_DB_STORAGE@dbCloneBundle@servletRequest"
                  renderedBinding="is10gOrHigher@dbCloneBean@servletRequest"/>
                <uix:choice id="storageType" name="storageType" 
                  selectedValueBinding="storageType@dbCloneBean@servletRequest"
                  renderedBinding="is10gOrHigher@dbCloneBean@servletRequest">
                  <uix:contents>
                    <uix:option textBinding="STORAGE_FILE_SYSTEM@dbCloneBundle@servletRequest" value="FILE_SYSTEM"/>
                    <uix:option textBinding="STORAGE_ASM@dbCloneBundle@servletRequest" value="ASM_STORAGE"/>
                    <%--<uix:option textBinding="STORAGE_RAW_DEVICE@dbCloneBundle@servletRequest" value="RAW_DEVICES"/>--%>
                  </uix:contents>
                </uix:choice>
              </uix:labeledFieldLayout>
              
            </uix:contents>
          </uix:header>
          
          <%--.................. Database storage .........................
          <uix:header textBinding="DEST_DB_STORAGE@dbCloneBundle@servletRequest">	
            <uix:contents>
          
              <uix:rowLayout>
                <uix:contents>
                  <uix:messageRadioButton
                    name="storageType"
                    selected="true"
                    textBinding="STORAGE_FILE_SYSTEM@dbCloneBundle@servletRequest"
                    value="FILE_SYSTEM"
                    selectedValueBinding="storageType@dbCloneBean@servletRequest"
                    messageBinding="STORAGE_FILE_SYSTEM_HINT@dbCloneBundle@servletRequest"/>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:contents>
                  <uix:messageRadioButton
                    name="storageType"
                    selected="false"
                    textBinding="STORAGE_ASM@dbCloneBundle@servletRequest"
                    value="CONVERT_ASM"
                    selectedValueBinding="storageType@dbCloneBean@servletRequest"
                    messageBinding="STORAGE_ASM_HINT@dbCloneBundle@servletRequest"/>
                </uix:contents>
              </uix:rowLayout>
            
            </uix:contents>
          </uix:header>
          --%>

          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
              <uix:navigationBar 
                name="dbCloneNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="dbCloneForm"
                maxValueBinding="maxNavValue@dbCloneBean@servletRequest"
                minValue="1"
                valueBinding="navValue@dbCloneBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
