<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/dbclone/remoteSelector.js"/>
 
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

  <uix:metaContainer> 
    <uix:head titleBinding="sourceOptionsPageTitle@dbCloneBean@servletRequest"/>
  </uix:metaContainer>

    <uix:body>
      <uix:contents>

      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_SourceOptions"/>
        <uix:formValue name="lovName"/>
        <uix:formValue name="fetchType"/>
        
        <uix:pageLayout titleBinding="SOURCE_OPTIONS_HEADER@dbCloneBundle@servletRequest" >
          <%@ include file="/database/global.jspf" %>

            <%-- Wizard train --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <%-- Error message --%>
            <%@ include file="/database/dbclone/errors.jspf" %>

            <%-- context info --%>
          <uix:pageStatus>
            <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
              <uix:case name="false">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcDbName@dbCloneBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>	
              </uix:case>
              <uix:case name="true">
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@dbCloneBean@servletRequest"/>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>

          <uix:separator/>
	
	 <%--....................... Start of included section .......................--%>
          <uix:stackLayout>
            <uix:contents>
              <%@ include file="/database/dbclone/sourceBackupSet.jspf" %>
            </uix:contents>
          </uix:stackLayout>

         <%--................... End of included section .............................--%>
	
	     <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest" 
                shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                destinationBinding="cancelURL@dbCloneBean@servletRequest"/>
               <uix:navigationBar name="dbCloneNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="dbCloneForm"
                maxValueBinding="maxNavValue@dbCloneBean@servletRequest"
                minValue="1"
                valueBinding="navValue@dbCloneBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
             
        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
