<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/page/LOV.js"/>

<SCRIPT LANGUAGE="JavaScript">

  function disableOnLoad () {
    var runningDbFlag = dbCloneForm.bsUsage[0].checked;

    if(runningDbFlag)
    {
      dbCloneForm.backupType[0].disabled=true;
      dbCloneForm.backupType[1].disabled=true;
      dbCloneForm.newCloneType[0].disabled=false;
      dbCloneForm.newCloneType[1].disabled=false;
    }
    else
    {
      dbCloneForm.backupType[0].disabled=false;
      dbCloneForm.backupType[1].disabled=false;
      dbCloneForm.newCloneType[0].disabled=true;
      dbCloneForm.newCloneType[1].disabled=true;
    }
  }//disableOnLoad

  function disableRadioButtons (val) {
    if(val=="1")
    {
      dbCloneForm.newCloneType[0].disabled=false;
      dbCloneForm.newCloneType[1].disabled=false;
      dbCloneForm.backupType[0].disabled=true;
      dbCloneForm.backupType[1].disabled=true;
    }
    else if(val=="2")
    {
      dbCloneForm.newCloneType[0].disabled=true;
      dbCloneForm.newCloneType[1].disabled=true;
      dbCloneForm.backupType[0].disabled=false;
      dbCloneForm.backupType[1].disabled=false;
    }
    else if(val=="3")
    {
      dbCloneForm.backupType[0].disabled=true;
      dbCloneForm.backupType[1].disabled=true;
    }
    else if(val=="4")
    {
      dbCloneForm.newCloneType[0].disabled=true;
      dbCloneForm.newCloneType[1].disabled=true;
    }
  }//disableRadioButtons

</SCRIPT>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="startingPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="disableOnLoad()">
      <uix:contents>

        <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
          <uix:formValue name="pageName" value="/database/dbclone/dbClone_StartingPage"/>

          <uix:pageLayout titleBinding="STARTING_PAGE_HEADER@dbCloneBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Error message --%>
            <%@ include file="/database/dbclone/errors.jspf" %>

            <uix:pageStatus>
              <uix:styledText styleClass="OraInstructionText"
                textBinding="CLONE_SOURCE_QUESTION_PROMPT@dbCloneBundle@servletRequest"/>
            </uix:pageStatus>

            <uix:tableLayout width="100%" summary="tl"> 
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>
                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer textBinding="OVERVIEW_TITLE@dbCloneBundle@servletRequest" width="450">
                          <uix:contents>

                            <%--  Bulleted look & feel, STARTS HERE   --%>

                            <uix:styledList listStyle="none">

                            <uix:separator>
                              <uix:spacer height="10"/>
                            </uix:separator>
                            <uix:contents>

                       <%--       <uix:styledList listStyle="circle">
                                <uix:separator>
                                  <uix:spacer height="0"/>
                                </uix:separator>
                                <uix:label>
                                  <uix:styledItem >
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_SOURCE@dbCloneBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:styledItem>
                                </uix:label>
                                <uix:contents>
                                  <uix:styledItem>
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_SOURCE1@dbCloneBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:styledItem>
                                  <uix:styledItem>
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_SOURCE2@dbCloneBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:styledItem>
                                  <uix:styledItem>
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_SOURCE3@dbCloneBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:styledItem>
                                </uix:contents>
                              </uix:styledList> --%>

                              <uix:styledList listStyle="disc">
                                <uix:separator>
                                  <uix:spacer height="5"/>
                                </uix:separator>
                                <uix:label>
                                  <uix:styledItem >
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_OPERATION@dbCloneBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:styledItem>
                                </uix:label>
                                <uix:contents>

                                  <uix:styledList listStyle="circle">
                                    <uix:separator>
                                      <uix:spacer height="0"/>
                                    </uix:separator>
                                    <uix:label>
                                      <uix:styledItem >
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                           textBinding="OVERVIEW_COPY_NET@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:label>
                                    <uix:contents>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_NET_1@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_NET_2@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_NET_3@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:contents>
                                  </uix:styledList>

                                  <uix:styledList listStyle="circle">
                                    <uix:separator>
                                      <uix:spacer height="0"/>
                                    </uix:separator>
                                    <uix:label>
                                      <uix:styledItem >
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_STG@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:label>
                                    <uix:contents>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_STG_1@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_STG_2@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_STG_3@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_COPY_STG_4@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:contents>
                                  </uix:styledList>

                                  <uix:styledList listStyle="circle">
                                    <uix:separator>
                                      <uix:spacer height="0"/>
                                    </uix:separator>
                                    <uix:label>
                                      <uix:styledItem >
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_EXISTING@dbCloneBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:label>
                                    <uix:contents>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_1@testDBMsgs"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_3@testDBMsgs"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                       <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_4@testDBMsgs"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                      <uix:styledItem>
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText"
                                            textBinding="OVERVIEW_5@testDBMsgs"/>
                                        </uix:contents>
                                      </uix:styledItem>
                                    </uix:contents>
                                  </uix:styledList>

                                </uix:contents>
                              </uix:styledList>

                              </uix:contents>
                            </uix:styledList>

                            <%--  Bulleted look & feel, ENDS HERE   --%>

                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>
                      <%-- Contents of borderLayout --%>
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>
                            <%--
                            <uix:styledText styleClass="OraInstructionText"
                                textBinding="STARTING_PAGE_INSTRUCTION@dbCloneBundle@servletRequest"/>
                            --%>

                            <%@ include file="/database/dbclone/startingPage.jspf" %>

                       <uix:spacer height="20"/>

                       <uix:switcher childNameBinding="isECMContext@dbCloneBean@servletRequest">
                        <uix:case name="false">
                         <uix:stackLayout renderedBinding="showSnapshot@dbCloneBean@servletRequest">
                         <uix:contents>
                         <uix:tip>
                          <uix:contents>
                           <uix:styledText
                             textBinding="STARTING_SNAPSHOT_TIP@dbCloneBundle@servletRequest"/>
                           </uix:contents>
                          </uix:tip>
                          <uix:spacer width="3"/>
                          <db:link textBinding="STARTING_SNAPSHOT_BUTTON@dbCloneBundle@servletRequest" renderedBinding="showSnapshot@dbCloneBean@servletRequest" destination="/console/database/dataguard/create?event=createSnapshot" copyParams="target,type"/>
                          </uix:contents>
                         </uix:stackLayout>
                        </uix:case>
                       </uix:switcher>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                  destinationBinding="cancelURL@dbCloneBean@servletRequest" shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"/>
                <uix:submitButton name ="event" formName="dbCloneForm"
                  textBinding="CONTINUE_BUTTON@dbCloneBundle@servletRequest"
                  value="continueEvent" shortDescBinding="CONTINUE_BUTTON@dbCloneBundle@servletRequest"/> 
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
