<%--
  -- Page:        dbClone_SubmitProcess.jsp
  -- Controller:  oracle.sysman.db.util.dbclone.DBCloneController
  --
  -- Description: Process (in progress) page displayed during processing for DBClone 
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBCloneMsgs"
              class="oracle.sysman.db.rsc.clone.DBCloneCommonMsg"/>
<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%-- <%@ include file="/enablePPR.jspf" %> --%>
    <%@ include file="/oemTitle.jspf" %>

    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="processingPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname,processId">
       <uix:formValue name="pageName" value="/database/dbclone/dbClone_Processing"/>

        <uix:pageLayout>
	  <%@ include file="/database/globalPopup.jspf" %>

          <uix:header textBinding="PROCESSING_HEADER@DBCloneMsgs"
                      iconBinding="processImage@servletRequest" >
            <uix:stackLayout>
              <%--
              <uix:spacer height="5" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="PROCESSING_HEADER@DBCloneMsgs"/>
              --%>
              <uix:spacer height="5" />
              <%--
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="PROCESSING_INSTRUCTION@DBCloneMsgs"/>
              <uix:spacer height="20"/> 
              --%>

              <uix:processing timeInterval="<%=processingPageInterval%>">
                <uix:styledText styleClass="OraProcessingStatusFixed"
                                textBinding="PROCESSING_INSTRUCTION@DBCloneMsgs"/>
              </uix:processing>
            </uix:stackLayout>
          </uix:header>

         <%--
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@DBObjectMsgs" 
                                name="event" 
                                value="cancelExtentMap"  shortDesc="image"/>  
            </uix:pageButtonBar>
          </uix:pageButtons>
          --%>

        </uix:pageLayout>
      </db:form>

    </uix:body>
  </uix:document> 
</uix:renderingContext>