<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="viewDatabaseFilesTitleText@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_ViewSourceDatabaseFiles"/>
        
        <uix:pageLayout titleBinding="viewDatabaseFilesHeaderText@dbCloneBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <uix:switcher childNameBinding="hideDBNameForECMExistingBackup@dbCloneBean@servletRequest">
              <uix:case name="false">
                <uix:formattedText styleClass="OraInstructionText" textBinding="reviewOverviewNewBS@dbCloneBean@servletRequest"/>
              </uix:case>
              <uix:case name="true">
                <uix:formattedText styleClass="OraInstructionText" textBinding="reviewOverviewExistingBS@dbCloneBean@servletRequest"/>
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>

          <uix:separator/>

          <uix:tableLayout width="100%" summary="tl"> 
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="viewDatabaseFilesInstruction@dbCloneBean@servletRequest"/>
            </uix:rowLayout>
          </uix:tableLayout>
          
          <%--...... Start of included section .............--%>
          <%@ include file="/database/dbclone/viewSourceDatabaseFiles.jspf" %>
          <%--...... End of included section ...............--%>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="RETURN_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="finishViewSourceDatabaseFiles" shortDescBinding="RETURN_BUTTON_TEXT@convertBundle@servletRequest"/> 
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
