<%--
  - FILE
  -   ExtendCluster.jsp
  -
  - DESCRIPTION
  -   The Extend Cluster main page, this page would consist of the 
  -   Clsuter Identification, the Target Selection, the Schedule
  -   and the Credntials sections.
  -
  - MODIFIED    (MM/DD/YY)
  -  rvaidhiy    03/07/09 - UI FIX
  -  rvaidhiy    03/05/09 - UI Fix
  -  rvaidhiy    03/04/09 - fixing UI COMMENTS
  -  rvaidhiy    06/23/08 - removing virtual ip
  -  rvaidhiy    10/19/07 - for ExtendCluster
  -  rvaidhiy    10/29/06 - 
  -  suravind    08/17/06 - XbranchMerge suravind_ec_directives from main
  -  suravind    08/08/06 - XbranchMerge suravind_ec_changes_review_page from
  -                         main
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  suravind    04/11/06 - Creation
  -
  - SINCE
  -  10.2+
  --%>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <%-- Header for the Extend Cluster page --%>
    <uix:header textBinding="EXTEND_CLUSTER_PAGE_HEADER@extendClusterRB">
      <%-- Header for the Extend Cluster - Cluster Identification section --%>
<%--      <uix:header text="">--%>
<%--        <uix:spacer width="100%" height="10"/>
        <uix:styledText 
             textBinding="CLUSTER_IDENTIFICATION_TEXT@extendClusterRB"
             styleClass="OraInstructionText"/>--%> 
        <uix:spacer width="100%" height="10"/>
        <uix:ref refID="DBEC_PAGE_SEGMENT_TYPE_RAC_REG_CLUSTERS"/>
		<%-- <uix:hideShowHeader
           id="sharedHomeHideShow"
           partialRenderMode="self"
           formSubmitted="true"
           textBinding="SHARED_HOME_SECTION_HEADER@extendClusterRB"
           disclosedBinding="hideShowDisclosed@SHARED_HOME_BEAN@servletRequest">
           <uix:spacer width="100%" height="10"/>
            <uix:table
             nameBinding="tableName@SHARED_HOME_BEAN@servletRequest"
             id="sharedHomeTable"
             summary="sharedHomeTable"
             partialRenderMode="self"
             formSubmitted="true"
             tableDataBinding="rows@SHARED_HOME_BEAN@servletRequest"
             valueBinding="currentValue@SHARED_HOME_BEAN@servletRequest"
             minValueBinding="minValue@SHARED_HOME_BEAN@servletRequest"
             blockSizeBinding="blockSize@SHARED_HOME_BEAN@servletRequest"
             maxValueBinding="maxValue@SHARED_HOME_BEAN@servletRequest"
             columnHeaderDataBinding="columnHeaders@SHARED_HOME_BEAN@servletRequest">
              <uix:columnHeaderStamp>
                <uix:text
                 textBinding="text">
                </uix:text>
              </uix:columnHeaderStamp>
              <uix:styledText
               id="oracleHomeLoc"
               labeledNodeId="oracleHomeLoc"
               textBinding="OH_LOC"
               shortDescBinding="SHARED_HOME_COLUMN_ORACLE_HOME_LOC@extendClusterRB"/>
              <uix:checkBox
               name="isShared"
               id="isShared"
               shortDescBinding="SHARED_HOME_COLUMN_IS_SHARED@extendClusterRB"
               disabledBinding="IS_DISABLED"
               checkedBinding="IS_SHARED"/>
            </uix:table>
           <uix:spacer width="100%" height="10"/>
           <uix:tip>
            <uix:styledText
                 textBinding="SHARED_HOME_TIP@extendClusterRB"
                 styleClass="OraPromptText"/>
           </uix:tip>
          </uix:hideShowHeader>--%>
		 <uix:spacer width="100%" height="10"/>

<%--      </uix:header>--%>
      <%-- Header for the Extend Cluster - Selected Targets section  --%>
      <uix:header 
        id="selectedTgtsHeader"
        textBinding="TARGET_SELECTION_HEADER@extendClusterRB">
        <uix:styledText 
             textBinding="hostTableAltHeadingText@servletRequest"
             styleClass="OraInstructionText"/>
        <uix:spacer width="100%" height="15"/>
        <%-- Selected Targets table --%>
<%--		<uix:stackLayout>
        <uix:rowLayout>
            <uix:cellFormat hAlign="left" width="50%">
                <uix:checkBox name="autoPopulateDefaults" disabledBinding="buttonsDisabled@servletRequest"
                textBinding="AUTO_POPULATE_DEFAULTS@extendClusterRB" primaryClientActionBinding="onClickAutoPopulate@servletRequest"/>
            </uix:cellFormat>
            </uix:rowLayout>
        </uix:stackLayout>--%>
        <uix:table 
             nameBinding="tableName@SEL_TAR_BEAN@servletRequest"
             id="hostTable"
             summary="hostTable"
             partialRenderMode="self"
             formSubmitted="true"
             tableDataBinding="rows@SEL_TAR_BEAN@servletRequest"
             valueBinding="currentValue@SEL_TAR_BEAN@servletRequest"
             minValueBinding="minValue@SEL_TAR_BEAN@servletRequest"
             blockSizeBinding="blockSize@SEL_TAR_BEAN@servletRequest"
             maxValueBinding="maxValue@SEL_TAR_BEAN@servletRequest"
             alternateTextBinding="hostTableAltText@servletRequest"
             columnHeaderDataBinding="columnHeaders@SEL_TAR_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>      
          <uix:tableActions >
		  	  <uix:flowLayout>
              <uix:cellFormat hAlign="left" width="5%">
		<uix:button 
		     name="addHosts"
                     textBinding="TARGET_SELECTION_TABLE_ACTION_ADD@extendClusterRB"
                     shortDescBinding="TARGET_SELECTION_TABLE_ACTION_ADD@extendClusterRB"
                     disabled="false"
                     primaryClientActionBinding="onClickAddHost@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="10%">
                <uix:button 
                     name="uploadCCF"
                     onClickBinding="ccfButtonOnClick@SEL_TAR_BEAN@servletRequest"
                     disabledBinding="buttonsDisabled@servletRequest"
                     shortDescBinding="TARGET_SELECTION_TABLE_ACTION_CCF@extendClusterRB"
                     textBinding="TARGET_SELECTION_TABLE_ACTION_CCF@extendClusterRB"/>   
              </uix:cellFormat>
        <%--      <uix:cellFormat hAlign="right" width="85%">
                <uix:hideShow
                     id="hostTableHideShow"
                     partialRenderMode="multiple" 
                     partialTargets="hostTable" 
                     formSubmitted="true"
                     undisclosedTextBinding="TARGET_SELECTION_TABLE_ACTION_ADV@extendClusterRB"
                     disclosedTextBinding="TARGET_SELECTION_TABLE_ACTION_SIMPLE@extendClusterRB"
                     disclosedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"/> 
             </uix:cellFormat>  
             --%>
	  </uix:flowLayout>
          </uix:tableActions>
		
          <uix:messageTextInput 
               name="pubHostName" 
               id="pubHostName" 
               shortDescBinding="TARGET_SELECTION_TABLE_COLUMN_HOST@extendClusterRB"
               disabledBinding="rowDisabled"
               columns="33" 
               required="uiOnly"
			   messageTypeBinding="PUBLICHOST_MSG_TYPE"
                       
               textBinding="HOST_NAME"/>

          <uix:messageTextInput 
               name="vipHostname" 
               id="vipHostname" 
               columns="33" 
               required="uiOnly"
               disabledBinding="colDisabled"
			     messageTypeBinding="VIP_MSG_TYPE"

               shortDescBinding="TARGET_SELECTION_TABLE_COLUMN_PRIV_NAME@extendClusterRB"
               textBinding="VIP_HOST"/>
       
          <uix:messageTextInput 
               name="tmpDir" 
               renderedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"
			   required="uiOnly"
			      messageTypeBinding="TMP_MSG_TYPE"

               shortDescBinding="TARGET_SELECTION_TABLE_COLUMN_PRIV_NAME@extendClusterRB"
               columns="34" 
               textBinding="TMP_DIR"/>
          <uix:image
               source="/em/images/deleteicon_enabled.gif"
               primaryClientActionBinding="REMOVE_DEST"
               hAlign="center"
               shortDescBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE@extendClusterRB"
               textBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE@extendClusterRB"/>
			  
          <%--
          <uix:footer>
            <uix:tableLayout width="100%">
              <uix:rowLayout width="50%" hAlign="right">
                <uix:button 
                     textBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE_ALL@extendClusterRB"
                     shortDescBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE_ALL@extendClusterRB"
                     disabledBinding="removeAllButtonDisabled@SEL_TAR_BEAN@servletRequest"
                     primaryClientActionBinding="onClickRemoveAllHosts@servletRequest"/>
              </uix:rowLayout>  
            </uix:tableLayout>
          </uix:footer>--%>
        </uix:table>      
      </uix:header>
      <%-- Credentials Section Starts --%>
      <uix:hideShowHeader 
           id="credsHideShow"
           partialRenderMode="multiple"
           partialTargets="credsCollapsedText"
           formSubmitted="true"
           textBinding="hideShowHeaderText@CREDENTIALS_BEAN@servletRequest"
           disclosedBinding="hideShowDisclosed@CREDENTIALS_BEAN@servletRequest">
        <uix:styledText 
             textBinding="CREDENTIALS_EXPANDED_TEXT@extendClusterRB"
             styleClass="OraInstructionText"/>
        <uix:header textBinding="CREDENTIALS_CLUSTER_HEADER@extendClusterRB">
          <uix:tip shortDescBinding="CREDENTIALS_CLUSTER_TIP@extendClusterRB">
            <uix:styledText
                 textBinding="CREDENTIALS_CLUSTER_TIP@extendClusterRB"
                 shortDescBinding="CREDENTIALS_CLUSTER_TIP@extendClusterRB"
                 renderedBinding="sudoTipRendered@CREDENTIALS_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:tip>
          <uix:ref refID="DBEC_PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_HOMES_INSTANCE"/>
        </uix:header>
        <uix:tableLayout width="100%">
          <uix:rowLayout
               renderedBinding="credsForLibStepRendered@CREDENTIALS_BEAN@servletRequest">
            <uix:header 
                 textBinding="CREDENTIALS_LIB_STEP_HEADER@extendClusterRB">
              <uix:ref refID="DBEC_PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_LS_INSTANCE"/>
            </uix:header>  
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:tableLayout width="100%">
          <uix:rowLayout
               renderedBinding="dbCredsSecRendered@CREDENTIALS_BEAN@servletRequest">
            <uix:header
                 textBinding="dbCredsHeaderText@CREDENTIALS_BEAN@servletRequest">
              <uix:ref refID="DBEC_PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_DB_INSTANCE"/>
            </uix:header>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:hideShowHeader>
      <uix:rowLayout id="credsCollapsedText">
        <uix:cellFormat width="5%">
          <uix:spacer/>         
        </uix:cellFormat>
        <uix:cellFormat width="90%">
          <uix:styledText 
               textBinding="CREDENTIALS_COLLAPSED_TEXT@extendClusterRB"
               renderedBinding="collapsedTextRendered@CREDENTIALS_BEAN@servletRequest"
               styleClass="OraInstructionText"/>
        </uix:cellFormat>
      </uix:rowLayout>  
      <%-- Credentials Section Ends --%>
      
      <%-- Page Segment for Schedule --%>
	<uix:ref refID="DBEC_PAGE_SEGMENT_TYPE_PROV_SCHEDULE"/>

	<%-- Prereqs and Fixups header --%>
	 <uix:hideShowHeader
           id="skipPrereqs"
           partialRenderMode="self"
           formSubmitted="true"
           textBinding="hideShowHeaderText@PREREQS_BEAN@servletRequest"
           disclosedBinding="hideShowDisclosed@PREREQS_BEAN@servletRequest">
             <uix:messageCheckBox
                        name="skipPrereqsChkBox"
                        id="skipPrereqsChkBox"
                        checkedBinding="skipPrereqs@PREREQS_BEAN@servletRequest"
                        primaryClientActionBinding="skipPrereqsChkedEvent@servletRequest"
                        textBinding="LBL_SKIP_PREREQS@extendClusterRB"/>
             <uix:tip
                textBinding="SKIP_PREREQ_TIP_TEXT@extendClusterRB">
             </uix:tip>
      </uix:hideShowHeader>


	</uix:header>
  </uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>

