<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
            </uix:rawText>
        </uix:case>
    </uix:switcher>

        <uix:document>
		<%@ include file="/oemTitle.jspf"%> 

            <uix:body>
              
                <db:form name="AdminOverviewForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
					<uix:formValue name="pageName" value="/database/dist/advRepl/admin/adminOverview"/>
					<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
					
					<%@ include file="/database/global.jspf" %>
					<%-- <uix:messages> --%>
					<oem:messageBox messageType="info" 
							  errorTableBinding="info@servletRequest"
							  titleTextKey="titleText" mainTextKey="mainText"/>
					<oem:messageBox messageType="error" 
							  errorTableBinding="errors@servletRequest"
							  titleTextKey="titleText" mainTextKey="mainText"/>            
					<%-- </uix:messages> --%>
                      
                        <uix:tableLayout width="100%">
                        
                          <uix:rowLayout>
                            
                              <uix:cellFormat width="100%" hAlign="right">
                                
                                  <uix:rowLayout>
                                     
                                        <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:submitButton textBinding="REFRESH@arAdminMsgs" name="event" value="refreshStatistics" shortDescBinding="REFRESH@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>  
                                        <uix:messageChoice promptBinding="VIEW_DATA@arAdminMsgs" shortDescBinding="VIEW_DATA@arAdminMsgs" name="refreshHome" 
                                         labeledNodeId="ViewData"
                                                          onChange="submitForm('AdminOverviewForm', true, {'event':'refreshStatistics'})"
                                                           selectedValueBinding="refreshHomeSelected@servletRequest" >

                                              <uix:option id="ViewData" textBinding="MANUAL_REFRESH@arAdminMsgs" shortDescBinding="MANUAL_REFRESH@arAdminMsgs" value="RT_MAN"/>
                                              <uix:option id="ViewData1" textBinding="AUTOMATIC_REFRESH@arAdminMsgs" shortDescBinding="AUTOMATIC_REFRESH@arAdminMsgs" value="RT_60"/>
                                                
                                         </uix:messageChoice>
                                   
                                   </uix:rowLayout>
                                
                                </uix:cellFormat>
                              
                              </uix:rowLayout>
                            
                        </uix:tableLayout>
                                <uix:spacer height="10" width="10"/>


							<uix:subTabBar selectedIndex="0">
								<uix:link textBinding="OVERVIEW@arAdminMsgs" selected="true"/>
								<db:link textBinding="STATISTICS@arAdminMsgs" 
									destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayAdminStats" 
									copyParams="target,type" />
								<db:link textBinding="PURGE_SCHEDULE@arAdminMsgs" 
									destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayPurgeSchedule" 
									copyParams="target,type" />
							</uix:subTabBar>

                                <uix:spacer height="10" width="10"/>

                                <uix:tableLayout styleClass="OraInstructionText">
                                  
                                    <uix:rowLayout>
                                      
                                      <%-- General Section --%>
                                        <uix:cellFormat vAlign="top" wrappingDisabled="true">
                                          
                                            <uix:header textBinding="GENERAL@arAdminMsgs">
                                              
                                                <uix:tableLayout styleClass="OraInstructionText" cellSpacing="5">
                                                  
                                                    <uix:rowLayout>
                                                      
                                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                          
                                                            <uix:styledText textBinding="SCHEDULED_LINKS@arAdminMsgs"/>
                                                          
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">

															<db:link textBinding="scheduledLinksCount@adminOverviewBean@servletRequest"  
															shortDescBinding="scheduledLinksCount@adminOverviewBean@servletRequest" 
															destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayScheduledLinks" 
															copyParams="type,target"
															/>

                                                        </uix:cellFormat>
                                                      
                                                    </uix:rowLayout>                                                    
                                                    <uix:rowLayout>
                                                      
                                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                          
                                                            <uix:styledText textBinding="DEFERRED_TRANSACTIONS@arAdminMsgs"/>
                                                          
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                          
                                                            <db:link textBinding="deferredTransactionsCount@adminOverviewBean@servletRequest"  
															shortDescBinding="deferredTransactionsCount@adminOverviewBean@servletRequest" 
															destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayDeferredTransactions" 
															copyParams="type,target"
															/>

                                                          
                                                        </uix:cellFormat>
                                                      
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                      
                                                        <uix:cellFormat hAlign="right">
                                                          
                                                            <uix:styledText textBinding="ERROR_TRANSACTIONS@arAdminMsgs"/>
                                                          
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                          
                                                            <db:link textBinding="errorTransactionsCount@adminOverviewBean@servletRequest" 
															shortDescBinding="errorTransactionsCount@adminOverviewBean@servletRequest" 
															destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayErrorTransactions" 
															copyParams="type,target"
															/>

                                                          
                                                        </uix:cellFormat>
                                                      
                                                    </uix:rowLayout>
                                                  
                                                </uix:tableLayout>
                                              
                                            </uix:header>

                                            <uix:header textBinding="MULTIMASTER_REPLICATION@arAdminMsgs" styleClass="OraInstructionText">
                                              
                                                <uix:tableLayout styleClass="OraInstructionText" cellSpacing="10">
                                                  
                                                    <uix:rowLayout>
                                                      
                                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                          
                                                            <uix:styledText textBinding="MASTER_GROUPS@arAdminMsgs"/>
                                                          
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="right">
                                                          
                                                            <db:link textBinding="masterGroupsCount@adminOverviewBean@servletRequest"  
															shortDescBinding="masterGroupsCount@adminOverviewBean@servletRequest" 
															destination="/console/database/dist/advRepl/masterGroup" copyParams="target,type"/>
                                                          
                                                        </uix:cellFormat>
                                                      
                                                    </uix:rowLayout>
                                                  
                                                </uix:tableLayout>
                                              
                                            </uix:header>										  

                                        </uix:cellFormat>
                                        
                                        <%-- Multimaster replication Summary Section --%>
                                        <%-- <uix:cellFormat vAlign="top">
                                          
                                            <uix:header textBinding="MULTIMASTER_REPLICATION@arAdminMsgs" styleClass="OraInstructionText">
                                              
                                                <uix:tableLayout styleClass="OraInstructionText" cellSpacing="10">
                                                  
                                                    <uix:rowLayout>
                                                      
                                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                          
                                                            <uix:styledText textBinding="MASTER_GROUPS@arAdminMsgs"/>
                                                          
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="right">
                                                          
                                                            <db:link textBinding="masterGroupsCount@adminOverviewBean@servletRequest"  
															shortDescBinding="masterGroupsCount@adminOverviewBean@servletRequest" 
															destination="/console/database/dist/advRepl/masterGroup" copyParams="target,type"/>
                                                          
                                                        </uix:cellFormat>
                                                      
                                                    </uix:rowLayout>
                                                  
                                                </uix:tableLayout>
                                              
                                            </uix:header>
                                          
                                        </uix:cellFormat> --%>
                                        
                                        <%-- Materialized view replication Summary Section --%>
                                        <uix:cellFormat vAlign="top">
                                          
                                            <uix:header textBinding="MATERIALIZED_VIEW_REPLICATION@arAdminMsgs">
                                              
                                            <uix:header textBinding="MASTER_SITE@arAdminMsgs" >
                                              
                                                <uix:tableLayout styleClass="OraInstructionText" cellSpacing="10">
                                                  
                                                <uix:rowLayout styleClass="OraInstructionText">
                                                  
                                                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                      
                                                        <uix:styledText textBinding="MATERIALIZED_VIEW_LOGS@arAdminMsgs"/>
                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <db:link textBinding="matViewLogsCount@adminOverviewBean@servletRequest"  
														shortDescBinding="matViewLogsCount@adminOverviewBean@servletRequest" 
														destination="/console/database/databaseObjectsSearch?event=noSearch&otype=schema&objectType=MATERIALIZED_VIEW_LOG"
                                                        copyParams="type,target"
														/>
                                                      
                                                    </uix:cellFormat>
                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout styleClass="OraInstructionText">
                                                  
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <uix:styledText textBinding="TEMPLATES@arAdminMsgs"/>
                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <db:link destination="/console/database/dist/advRepl/templateAdmin?event=TemplateAdmin" 
														copyParams="type,target"
														textBinding="templatesCount@adminOverviewBean@servletRequest"
														shortDescBinding="templatesCount@adminOverviewBean@servletRequest" 
														/>
                                                      
                                                    </uix:cellFormat>
                                                  
                                                </uix:rowLayout>
                                              
                                              </uix:tableLayout>
                                              
                                            </uix:header>
                                            <uix:header textBinding="MATERIALIZED_VIEW_SITE@arAdminMsgs">
                                              
                                                <uix:tableLayout cellSpacing="10">                                
                                                  
                                                <uix:rowLayout styleClass="OraInstructionText">
                                                  
                                                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                        <uix:styledText textBinding="MATERIALIZED_VIEW_GROUPS@arAdminMsgs"/>
                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <db:link  destination="/console/database/dist/advRepl/matViewGroup?otype=MATVIEW_GROUP&objectType=MATVIEW_GROUP"  
														copyParams="type,target" 
														textBinding="matViewGroupsCount@adminOverviewBean@servletRequest"
														shortDescBinding="matViewGroupsCount@adminOverviewBean@servletRequest" 
														/>
                                                      
                                                    </uix:cellFormat>
                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout styleClass="OraInstructionText">
                                                  
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <uix:styledText textBinding="MATERIALIZED_VIEWS@arAdminMsgs"/>
                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <db:link destination="/console/database/databaseObjectsSearch?event=noSearch&otype=schema&objectType=MATERIALIZED_VIEW" 
														copyParams="type,target" 
														textBinding="matViewsCount@adminOverviewBean@servletRequest" 
														shortDescBinding="matViewsCount@adminOverviewBean@servletRequest" 
														/>
                                                      
                                                    </uix:cellFormat>
                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout styleClass="OraInstructionText">
                                                  
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <uix:styledText textBinding="REFRESH_GROUPS@arAdminMsgs"/>
                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="right">
                                                      
                                                        <db:link destination="/console/database/databaseObjectsSearch?event=noSearch&otype=schema&objectType=REFRESH_GROUP"  
														copyParams="type,target" 
														textBinding="refreshGroupsCount@adminOverviewBean@servletRequest"  
														shortDescBinding="refreshGroupsCount@adminOverviewBean@servletRequest" 
														/>
                                                      
                                                    </uix:cellFormat>
                                                  
                                                </uix:rowLayout>
                                                  
                                                </uix:tableLayout>
                                              
                                            </uix:header>
                                              
                                            </uix:header>
                                          
                                        </uix:cellFormat>
                                <uix:cellFormat vAlign="top" hAlign="right" width="50%">
                                  
                                    <uix:contentContainer background="light" rendered="true" textBinding="OVERVIEW@arAdminMsgs"  shortDescBinding="OVERVIEW@arAdminMsgs" width="90%">                                      
                                        <uix:stackLayout rendered="true">
                                          
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="MULTIMASTER_REPLICATION@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="MULTIMASTER_REPLICATION_MSG@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="MATERIALIZED_VIEW_REPLICATION@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="MATERIALIZED_VIEW_REPLICATION_MSG@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="ERROR_TRANSACTIONS@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="ERROR_TRANSACTIONS_MSG@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="DEFERRED_TRANSACTIONS@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="DEFERRED_TRANSACTIONS_MSG@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              
                                                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="SCHEDULED_LINKS@arAdminMsgs"/>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="SCHEDULED_LINKS_MSG@arAdminMsgs"/>
                                            </uix:rowLayout>
                                          
                                        </uix:stackLayout>
                                      
                                    </uix:contentContainer>
                                  
                                </uix:cellFormat>
                                        
                                        <%-- Overview Summary Section --%>
                                      
                                    </uix:rowLayout>
                                  
                                </uix:tableLayout>
                                <uix:spacer height="10" width="10"/>
                                
                      <%--<uix:header textBinding="TOPOLOGY@arAdminMsgs">
					  </uix:header>--%>

                      <uix:header textBinding="RELATED_LINKS@arAdminMsgs">
                            <uix:bulletedList>                              
                                <db:link  textBinding="INITIALIZATION_PARAMETERS@arAdminMsgs" 
									destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayInitParams" 
									copyParams="type,target"/>
                                <db:link textBinding="SETUP@arAdminMsgs" destination="/console/database/dist/advRepl/setup?event=showOptions&previousPage=dbAdmin" copyParams="target,type"/>
                                <db:link textBinding="JOBS@arAdminMsgs" 
								destination="/console/database/instance/schr/jobs" copyParams="target,type"
								/>
                            </uix:bulletedList>                        
                      </uix:header>
                      <uix:spacer height="10" width="10"/>                    
                      
                      
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
</uix:renderingContext> 
