<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>

<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
	<db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
            </uix:rawText>
        </uix:case>
    </uix:switcher>

        <uix:document>        	
            <%@ include file="/oemTitle.jspf"%>
        	
            <uix:body>
              
                <db:form name="AdminStatisticsForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type">
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/adminStatistics"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                
                    <uix:pageLayout titleBinding="header@servletRequest">                  
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                    
                      
                          <uix:tableLayout width="100%">
                        
                          <uix:rowLayout>
                            
                              <uix:cellFormat width="100%" hAlign="right">
                                
                                  <uix:rowLayout>
                                     
                                        <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:submitButton textBinding="REFRESH@arAdminMsgs" name="event" value="refreshStatistics" shortDescBinding="REFRESH@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>  
                                        <uix:messageChoice promptBinding="VIEW_DATA@arAdminMsgs" shortDescBinding="VIEW_DATA@arAdminMsgs" name="refreshHome" id="ViewLabel"
                                                          onChange="submitForm('AdminStatisticsForm', true, {'event':'refreshStatistics'})"
                                                           selectedValueBinding="refreshHomeSelected@servletRequest" >

                                              <uix:option textBinding="MANUAL_REFRESH@arAdminMsgs" shortDescBinding="MANUAL_REFRESH@arAdminMsgs" value="RT_MAN"/>
                                              <uix:option textBinding="AUTOMATIC_REFRESH@arAdminMsgs" shortDescBinding="AUTOMATIC_REFRESH@arAdminMsgs" value="RT_60"/>
                                                
                                         </uix:messageChoice>
                                   
                                   </uix:rowLayout>
                                
                                </uix:cellFormat>
                              
                              </uix:rowLayout>
                            
                        </uix:tableLayout>
                            <uix:spacer width="10" height="10"/>
                            <uix:subTabLayout styleClass="OraInstructionText">
                             <uix:subTabs>
                                <uix:subTabBar styleClass="OraInstructionText">
                                  
                                    <db:link textBinding="OVERVIEW@arAdminMsgs" 
										destination="/console/database/dist/advRepl/advReplicationAdmin" 
										copyParams="target,type" />
									<db:link textBinding="STATISTICS@arAdminMsgs" selected="true" 
										destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayAdminStats" 
										copyParams="target,type" />
									<db:link textBinding="PURGE_SCHEDULE@arAdminMsgs"  
										destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayPurgeSchedule" 
										copyParams="target,type" />




                                </uix:subTabBar>
                              </uix:subTabs>
                              
                            <uix:tableLayout>
                              
                                <uix:rowLayout>
                                  
                                    <uix:formattedText textBinding="STATISTICS_TIP@arAdminMsgs" styleClass="OraInstructionText"/>
                                  
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents/>
                                    </uix:cellFormat>
                                  
                                </uix:rowLayout>
                              
                            </uix:tableLayout>

                            <uix:header textBinding="SCHEDULED_LINK_STATS@arAdminMsgs">
                              
                                <uix:rowLayout>                                  
                                <uix:formattedText textBinding="SCHEDULED_LINK_STATS_MSG@arAdminMsgs"  styleClass="OraInstructionText"/>
                                  
                                </uix:rowLayout>
                                <uix:spacer height="10" width="10"/>

								<uix:dataScope currentDataBinding="scheduledLinkStatsList@adminStatisticsBean@servletRequest">
								<uix:table name="scheduledLlinkStatsTable" 
										alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
										formSubmitted="true"
										width="100%"
										tableDataBinding="rowData"
										minValue="1"
										valueBinding="startIndex"
										blockSizeBinding="blockTab" 
										maxValueBinding="numRows"
										shortDescBinding="SCHEDULED_LINK_STATS@arAdminMsgs"
										summaryBinding="SCHEDULED_LINK_STATS@arAdminMsgs" >
                                  
                                    <%-- Database Links column --%>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="DATABASE_LINK@arAdminMsgs"/>
                                      </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" />
                                        <uix:styledText textBinding="<%= ARAdminMsgID.DATABASE_LINK%>"/>
                                    </uix:column>

                                    <uix:columnGroup>
                                      
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="ROUND_TRIPS_TOTAL@arAdminMsgs"/>
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.ROUND_TRIPS_TOTAL%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="ROUND_TRIPS_PER_TRANSACTION@arAdminMsgs" />
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.ROUND_TRIPS_PER_TRANSACTION%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                      
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="ROUND_TRIPS@arAdminMsgs"/>
                                      </uix:columnHeader>
                                    </uix:columnGroup>
                                    
                                    <uix:columnGroup>
                                      
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TRANSACTIONS_TOTAL@arAdminMsgs"/>
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.TRANSACTIONS_TOTAL%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TRANSACTIONS_ERROR@arAdminMsgs" />
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.TRANSACTIONS_ERROR%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                      
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="TRANSACTIONS@arAdminMsgs"/>
                                      </uix:columnHeader>
                                    </uix:columnGroup>
                                    
                                    <uix:columnGroup>
                                      
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TOTALBYTES_SENT@arAdminMsgs"/>
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.TOTALBYTES_SENT%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TOTALBYTES_RECEIVED@arAdminMsgs"/>
                                          </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                          
                                            <uix:styledText textBinding="<%= ARAdminMsgID.TOTALBYTES_RECEIVED%>" styleClass="OraInstructionText"/>
                                          
                                        </uix:column>
                                      
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="TOTALBYTES@arAdminMsgs"/>
                                      </uix:columnHeader>
                                    </uix:columnGroup>

										<uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TOTAL_ADMINREQUESTS@arAdminMsgs"/>
                                          </uix:columnHeader>                                
                                            <uix:columnFormat columnDataFormat="numberFormat"/>										  
                                            <uix:styledText textBinding="<%= ARAdminMsgID.TOTAL_ADMINREQUESTS%>" styleClass="OraInstructionText"/>                                          
                                        </uix:column>
                                      
                                                                        
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="AVGBYTES_PER_TRANSACTION@arAdminMsgs"/>
                                      </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="numberFormat"/>                                    
                                        <uix:styledText textBinding="<%= ARAdminMsgID.AVGBYTES_PER_TRANSACTION%>" styleClass="OraInstructionText"/>
                                      
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="AVERAGE_THROUGHPUT@arAdminMsgs"/>
                                      </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                       
                                        <uix:styledText textBinding="<%= ARAdminMsgID.AVERAGE_THROUGHPUT%>" styleClass="OraInstructionText"/>
                                      

                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="AVERAGE_LATENCY@arAdminMsgs"/>
                                      </uix:columnHeader>
                                          <uix:columnFormat columnDataFormat="numberFormat"/>                                      
                                        <uix:styledText textBinding="<%= ARAdminMsgID.AVERAGE_LATENCY%>" styleClass="OraInstructionText"/>
                                      
                                    </uix:column>

                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="TOTAL_SLEEP_TIME@arAdminMsgs"/>
                                      </uix:columnHeader>                                    
                                          <uix:columnFormat columnDataFormat="numberFormat"/>									  
                                        <uix:styledText textBinding="<%= ARAdminMsgID.TOTAL_SLEEP_TIME%>" styleClass="OraInstructionText"/>
                                    </uix:column>

                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader sortable="no" textBinding="PERCENT_SLEEPING@arAdminMsgs"/>
                                      </uix:columnHeader>                                    
                                          <uix:columnFormat columnDataFormat="numberFormat"/>									  
                                        <uix:styledText textBinding="<%= ARAdminMsgID.PERCENT_SLEEPING%>" styleClass="OraInstructionText"/>
                                    </uix:column>
								 
                                     <uix:tableSelection>
                                          <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@arAdminMsgs">
                                               <uix:contents>
												   <uix:submitButton textBinding="CLEAR_STATISTICS@arAdminMsgs" shortDescBinding="CLEAR_STATISTICS@arAdminMsgs" name="event" value="clearStatistics"/>
                                                </uix:contents>
                                           </uix:singleSelection>
                                 </uix:tableSelection>


                                </uix:table>
								</uix:dataScope>                                

                                </uix:header>
                                <uix:spacer height="30" width="10"/>
                                <uix:header textBinding="TRANSACTION_QUEUE_STATISTICS@arAdminMsgs">
                                  
                                <uix:tableLayout cellSpacing="10">
                                  
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="AVERAGE_NUMOF_CALLS@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="averageNumOfCalls@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="CALLS_ENQUEUED@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="callsEnqueued@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="INCOMING_RATEOF_TRANS@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="incomingRateOfTrans@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="LAST_ENQUEUE_TIME@arAdminMsgs"  styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="lastEnqueueTime@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="LAST_PURGE_TIME@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="lastPurgeTime@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText  textBinding="TRANSACTIONS_ENQUEUED@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="transactionsEnqueued@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      
                                        <uix:cellFormat hAlign="right">
                                          
                                            <uix:styledText textBinding="TRANSACTIONS_PURGED@arAdminMsgs" styleClass="OraInstructionText"/>
                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          
                                            <uix:styledText textBinding="transactionsPurged@adminStatisticsBean@servletRequest" styleClass="OraDataText"/>
                                          
                                        </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                  
                                </uix:tableLayout>
                                                                  
                                </uix:header>
                                <uix:spacer height="10" width="10"/>                                
                            
                            </uix:subTabLayout>
                                          
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
</uix:renderingContext> 