<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="ARInitParametersForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/arInitParams"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>

					  <!-- Main contents begin -->

                  <uix:contents>
                    <uix:spacer height="10" width="10"/>
		    
                    <uix:header textBinding="globalNamesName@arInitParametersBean@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="GLOBAL_NAMES_MESG@arAdminMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="globalNamesName@arInitParametersBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="globalNamesValue@arInitParametersBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@arAdminMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif" 
										shortDescBinding="INITIALIZATION_PARAMETERS@arAdminMsgs"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@arAdminMsgs" destinationBinding="globalNamesURL@arInitParametersBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>
		    
                    <uix:header textBinding="jobQueueProcessesName@arInitParametersBean@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="JOB_QUEUE_PROCESSES_MSG@arAdminMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="jobQueueProcessesName@arInitParametersBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="jobQueueProcessesValue@arInitParametersBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@arAdminMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"
										shortDescBinding="INITIALIZATION_PARAMETERS@arAdminMsgs"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@arAdminMsgs" destinationBinding="jobQueueProcessURL@arInitParametersBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>    
		    
                    <uix:spacer height="10" width="10"/>                  
                    
                  </uix:contents>

                      <!-- Main contents end -->
                      
            </uix:pageLayout>
            </db:form>
        </uix:body>
        </uix:document>
</uix:renderingContext>
