<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>

<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>
	<uix:bundle name="ScheduleBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
            </uix:rawText>
        </uix:case>
    </uix:switcher>

        <uix:document>
            <%@ include file="/oemTitle.jspf"%>          
            <uix:body>
              
                <db:form name="PurgeScheduleForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type">
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/purgeSchedule"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>                  

                    <uix:pageLayout titleBinding="header@servletRequest">                  
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                      
                        <uix:tableLayout width="100%">
                        
                          <uix:rowLayout>
                            
                              <uix:cellFormat width="100%" hAlign="right">
                                
                                  <uix:rowLayout>
                                     
                                        <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:submitButton textBinding="REFRESH@arAdminMsgs" name="event" value="refreshStatistics" shortDescBinding="REFRESH@arAdminMsgs"/>
                                        <uix:spacer height="10" width="10"/>  
                                        <uix:messageChoice promptBinding="VIEW_DATA@arAdminMsgs" shortDescBinding="VIEW_DATA@arAdminMsgs" name="refreshHome" id="ViewLabel"
                                                          onChange="submitForm('PurgeScheduleForm', true, {'event':'refreshStatistics'})"
                                                           selectedValueBinding="refreshHomeSelected@servletRequest" >

                                              <uix:option textBinding="MANUAL_REFRESH@arAdminMsgs" shortDescBinding="MANUAL_REFRESH@arAdminMsgs" value="RT_MAN"/>
                                              <uix:option textBinding="AUTOMATIC_REFRESH@arAdminMsgs" shortDescBinding="AUTOMATIC_REFRESH@arAdminMsgs" value="RT_60"/>
                                                
                                         </uix:messageChoice>
                                   
                                   </uix:rowLayout>
                                
                                </uix:cellFormat>
                              
                              </uix:rowLayout>
                            
                        </uix:tableLayout>
                            <uix:spacer width="10" height="10"/>
                            <uix:subTabLayout styleClass="OraInstructionText">
                             <uix:subTabs>
                                <uix:subTabBar styleClass="OraInstructionText">
                                  
                                    <db:link textBinding="OVERVIEW@arAdminMsgs" 
										destination="/console/database/dist/advRepl/advReplicationAdmin" 
										copyParams="target,type" />
									<db:link textBinding="STATISTICS@arAdminMsgs" 
										destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayAdminStats" 
										copyParams="target,type" />
									<db:link textBinding="PURGE_SCHEDULE@arAdminMsgs"  selected="true"
										destination="/console/database/dist/advRepl/advReplicationAdmin?event=displayPurgeSchedule" 
										copyParams="target,type" />
								  
                                </uix:subTabBar>
                              </uix:subTabs>
                              
                                <uix:spacer height="5" width="5"/>
                                  <uix:tableLayout width="100%">
                                    
                                    <uix:rowLayout>
                                      
                                         <uix:cellFormat width="100%" hAlign="right">
                                          
                                            <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="onPurge"/>

											<uix:spacer height="5" width="5"/>
                                          
                                          </uix:cellFormat>
                                      
                                    </uix:rowLayout>
                                  
                                  </uix:tableLayout>
                                
								<uix:header textBinding="SCHEDULE@arAdminMsgs">
								<uix:spacer height="10" width="10"/>

                                <uix:tableLayout cellSpacing="5">
                                  
                                      <uix:rowLayout>
                                          
                                            <uix:cellFormat hAlign="left" vAlign="top">
                                              
                                                <uix:messageRadioButton name="enableStatus" value = "false" selectedValueBinding="enableStatus@purgeScheduleBean@servletRequest" textBinding="DISABLE@arAdminMsgs" shortDescBinding="DISABLE@arAdminMsgs"  />
                                              
                                            </uix:cellFormat>
                                          
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          
                                             <uix:cellFormat hAlign="left" vAlign="top">
                                              
                                                <uix:messageRadioButton name="enableStatus" value = "true" selectedValueBinding="enableStatus@purgeScheduleBean@servletRequest" textBinding="ENABLE@arAdminMsgs" shortDescBinding="ENABLE@arAdminMsgs" />
                                            </uix:cellFormat>
                                        </uix:rowLayout>


                                            <uix:spacer height="10" width="10"/>
                                        <uix:rowLayout>
										
                                             <uix:tableLayout cellSpacing="10">
                                                        <uix:rowLayout>
                                                          
                                                <uix:cellFormat>
                                                  
                                                    <uix:tableLayout cellSpacing="5">
                                                      
                                                        <%--
														<uix:rowLayout>
                                                          
                                                            <uix:cellFormat hAlign="right" vAlign="top">
                                                              
                                                                <uix:styledText styleClass="OraInstructionText" textBinding="SIMPLE@arAdminMsgs"/>
                                                              
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left" vAlign="top">
                                                              
                                                                <uix:messageRadioButton name="dateOption" selected="true" value="simple" />
                                                              
                                                            </uix:cellFormat>
                                                          
                                                        </uix:rowLayout>
														--%>

                                                        <uix:rowLayout>
                                                          
                                                            <uix:cellFormat hAlign="right" vAlign="top">
                                                              
                                                                <uix:styledText styleClass="OraInstructionText" textBinding="NEXT_DATE@arAdminMsgs" 
                                                                labeledNodeId="startDateSB"/>
                                                              
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left" vAlign="top">
                                                              <uix:messageDateField 
																id="startDateSB"
								                                name="startDateSB"
							                             valueBinding="startDateSB@schedule@purgeScheduleBean@servletRequest"
						                                tipBinding="dateTip@schedule@purgeScheduleBean@servletRequest"
						                                shortDescBinding="START_DATE@ScheduleBundle">                         
												        <uix:onSubmitValidater>
							                                <uix:date dateStyle="medium"/>
														</uix:onSubmitValidater>
								                        </uix:messageDateField>
							                           </uix:cellFormat>
                                                          
                                                        </uix:rowLayout>

<!-- Time row -->
                  <uix:rowLayout>
                     <uix:cellFormat hAlign="right" vAlign="top">
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="TIME@ScheduleBundle"/>
                          </uix:contents>
                     </uix:cellFormat>
                     <uix:cellFormat>
                        <uix:rowLayout>
                                    <uix:cellFormat>
                                       <%-- START HOUR --%>
                                       <oem:choice
                                            name="startHourSB"
                                            id="startTimeID"
                                            optionsBinding="hoursSB@schedule@purgeScheduleBean@servletRequest" 
                                            shortDescBinding="HOURS@ScheduleBundle"
                                            selectedValueBinding="startHourSB@schedule@purgeScheduleBean@servletRequest"/>
                                      </uix:cellFormat>
                                      <uix:spacer height="5" width="5"/>
                                      <uix:cellFormat>
                                     <%-- START MINUTE --%>
                                       <oem:choice 
                                            name="startMinuteSB" 
                                            id="startTimeIDMIN"
                                            shortDescBinding="MINUTES@ScheduleBundle"
                                            optionsBinding="minutesSB@schedule@purgeScheduleBean@servletRequest" 
                                            selectedValueBinding="startMinuteSB@schedule@purgeScheduleBean@servletRequest"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <uix:cellFormat>
                                     <%-- START SECOND --%>
                                          <oem:choice 
                                               name="startSecondSB" 
                                               id="startTimeIDSEC"
                                               shortDescBinding="SECONDS@ScheduleBundle"
                                               optionsBinding="secondsSB@schedule@purgeScheduleBean@servletRequest" 
                                               selectedValueBinding="startSecondSB@schedule@purgeScheduleBean@servletRequest"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <%-- START AM/PM --%>
                                       <uix:cellFormat>
                                          <oem:radioButton
                                               name="startAmPmSB" 
                                               value="AM_VALUE"
                                               selectedValueBinding="startAmPmSB@schedule@purgeScheduleBean@servletRequest"
                                               textBinding="AM_LABEL@ScheduleBundle"
                                               shortDescBinding="AM_LABEL@ScheduleBundle"
                                               styleClass="OraInstructionText"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <uix:cellFormat>
                                          <oem:radioButton
                                               name="startAmPmSB" 
                                               value="PM_VALUE"
                                               selectedValueBinding="startAmPmSB@schedule@purgeScheduleBean@servletRequest"
                                               textBinding="PM_LABEL@ScheduleBundle"
                                               shortDescBinding="PM_LABEL@ScheduleBundle"
                                               styleClass="OraInstructionText"/>
                                       </uix:cellFormat>
									   

                        </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

					<!-- Interval Row -->
                  <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" vAlign="top">
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="EVERY@arAdminMsgs"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="top">
                          <uix:contents>
                            <uix:tableLayout cellSpacing="2">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                       <uix:messageTextInput
                                            id="repeatCountSBID"
                                            name="repeatCountSB"
                                            textBinding="repeatCountSB@schedule@purgeScheduleBean@servletRequest"
                                            shortDescBinding="FREQUENCY@ScheduleBundle"
                                            columns="10"> 
                                         <uix:onSubmitValidater>
                                            <uix:decimal maxScale="0"/>
                                        </uix:onSubmitValidater>
                                      </uix:messageTextInput>  

                                    </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                      <oem:choice 
                                         name="repeatIntervalSB"
                                         id="repeatCountSBIDINT"
                                         optionsBinding="intervalsSB@schedule@purgeScheduleBean@servletRequest"
                                         shortDescBinding="INTERVAL@ScheduleBundle"
                                         selectedValueBinding="repeatIntervalSB@schedule@purgeScheduleBean@servletRequest"/>

                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>

                                                 </uix:tableLayout>
                                                 
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left" vAlign="top">
                                                  <%-- 
                                                    <uix:tableLayout cellSpacing="5">
                                                      
                                                        <uix:rowLayout>
                                                          
                                                            <uix:cellFormat>
                                                              
                                                                <uix:styledText textBinding="ADVANCED@arAdminMsgs" styleClass="OraInstructionText"/>
                                                              
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                              
                                                                <uix:messageRadioButton name="dateOption" value="advanced"/>
                                                              
                                                            </uix:cellFormat>
                                                          
                                                        </uix:rowLayout>
                                                        <uix:rowLayout>
                                                          
                                                            <uix:cellFormat/>
                                                            <uix:cellFormat>
                                                              
                                                                <uix:messageTextInput name="advDate" tipBinding="ADVANCED_MSG@arAdminMsgs" columns="30"/>
                                                              
                                                            </uix:cellFormat>
                                                          
                                                        </uix:rowLayout>
                                                      
                                                    </uix:tableLayout>
													--%>
                                                  
                                                </uix:cellFormat>
                                                          
                                                        </uix:rowLayout>
                                            
                                        </uix:tableLayout>											
                                        </uix:rowLayout>	
                                        </uix:tableLayout>                                
										</uix:header>


	                                        <uix:spacer height="10" width="10"/>

                                            <uix:header textBinding="OPTIONS@arAdminMsgs" >
	                                        <uix:spacer height="10" width="10"/>
                                            <uix:tableLayout>                                                                        
	                                        <uix:spacer height="10" width="10"/>

											<uix:rowLayout>
	                                            <uix:cellFormat hAlign="left" vAlign="top">
												<uix:spacer height="10" width="10"/>
												</uix:cellFormat>
											</uix:rowLayout>


											<uix:rowLayout hAlign="left">
                                              
                                                <uix:cellFormat hAlign="right" vAlign="top">
                                                  
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="DELAY_SECONDS@arAdminMsgs" 
                                                    labeledNodeId="delaySeconds"/>
                                                  
                                                </uix:cellFormat>


                                                <uix:cellFormat hAlign="left" vAlign="top">
                                                  
                                                    <uix:messageTextInput columns="10" name="delaySeconds" id="delaySeconds"
                                                    textBinding="delaySeconds@purgeScheduleBean@servletRequest" 
                                                    tipBinding="DELAY_SECONDS_MSG@arAdminMsgs" 
                                                    shortDescBinding="DELAY_SECONDS@arAdminMsgs">
                                                      <uix:onBlurValidater>
                                                        <uix:decimal maxScale="0"/>
                                                      </uix:onBlurValidater>
                                                    </uix:messageTextInput>
                                                  
                                                </uix:cellFormat>
                                              
                                            </uix:rowLayout>

											<uix:rowLayout>
	                                            <uix:cellFormat hAlign="left" vAlign="top">
												<uix:spacer height="10" width="10"/>
												</uix:cellFormat>
											</uix:rowLayout>
                                            
											<uix:rowLayout>
                                              
                                                <uix:cellFormat hAlign="right" vAlign="top">
                                                  
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="USING_ROLLBACK_SEGS@arAdminMsgs"
                                                    labeledNodeId="rollbackSegments"/>
													<uix:spacer height="10" width="10"/>
                                                </uix:cellFormat>

                                                <uix:cellFormat>

												<oem:choice  name="rollbackSegment" id="rollbackSegments"  
												optionsBinding="rollbackSegmentsList@purgeScheduleBean@servletRequest" 
												selectedValueBinding="rollbackSegment@purgeScheduleBean@servletRequest" 
                                                shortDescBinding="rollbackSegment@purgeScheduleBean@servletRequest" 
												/>
                                                </uix:cellFormat>
                                              
                                            </uix:rowLayout>
                                        </uix:tableLayout>
                                        </uix:header>
												<uix:spacer height="10" width="10"/>
                            
                            </uix:subTabLayout>
                      
                    
                      <uix:pageStatus />                        
					  
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
</uix:renderingContext> 
