<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
	<db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="ScheduledLinksListForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/scheduledLinksList"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>


					<uix:spacer height="10" width="10"/>

					<uix:dataScope currentDataBinding="scheduledLinksListBean@servletRequest">
					<uix:table name="scheduledLinksTable" 
							alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
							formSubmitted="true"
							width="100%"
							tableDataBinding="rowData"
							minValue="1"
							valueBinding="startIndex"
							blockSizeBinding="blockTab" 
							maxValueBinding="numRows"
							shortDescBinding="SCHEDULED_LINKS_LIST@arAdminMsgs"
							summaryBinding="SCHEDULED_LINKS_LIST@arAdminMsgs" >
                                     
							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="DATABASE_LINK@arAdminMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= ARAdminMsgID.DATABASE_LINK%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="JOB_ID@arAdminMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= ARAdminMsgID.JOB_ID%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="JOB_OWNER@arAdminMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= ARAdminMsgID.JOB_OWNER%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="START_DATE@arAdminMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= ARAdminMsgID.START_DATE%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="LAST_PUSHED@arAdminMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= ARAdminMsgID.LAST_PUSHED%>"/>
							</uix:column>
                                     
							 <uix:tableSelection>
									  <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@arAdminMsgs">
										   <uix:contents>
											   <uix:submitButton textBinding="EDIT@dbMsgs" shortDescBinding="EDIT@dbMsgs" name="event" value="editScheduledLink"/>
											   <uix:submitButton textBinding="PUSH_SCHEDULE@arAdminMsgs" shortDescBinding="PUSH_SCHEDULE@arAdminMsgs" name="event" value="pushScheduledLink"/>
											</uix:contents>
									   </uix:singleSelection>
							 </uix:tableSelection>
                                                               
					</uix:table>
					</uix:dataScope>

					<uix:spacer height="10" width="10"/>
		  
                    
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="SCHEDULED_LINKS_MESSAGE@arAdminMsgs"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
</uix:renderingContext> 
