<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="TransactionDetailsForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/transactionDetails"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                    
                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                    <uix:styledText textBinding="OPERATION@arAdminMsgs" styleClass="OraInstructionText"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                    <uix:styledText textBinding="OPERATION_NAME@transactionDetailsListBean@servletRequest" styleClass="OraDataText"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                        
                        <uix:spacer height="10" width="10"/>
                        
						<uix:dataScope currentDataBinding="transactionDetailsListBean@servletRequest">
							<uix:table name="transactionDetailsListTable" 
									alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
									formSubmitted="true"
									width="100%"
									tableDataBinding="rowData"
									minValue="1"
									valueBinding="startIndex"
									blockSizeBinding="blockTab" 
									maxValueBinding="numRows"
									shortDescBinding="TRANSACTION_DETAILS_LIST@arAdminMsgs"
									summaryBinding="TRANSACTION_DETAILS_LIST@arAdminMsgs" >
                              
								<uix:column>
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="COLUMN@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.COLUMN%>"/>
								</uix:column>
                      
								<uix:column>
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="DATA_TYPE@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.DATA_TYPE%>"/>
								</uix:column>

								<uix:column renderedBinding="ORG_VALUE_RENDERED@transactionDetailsListBean@servletRequest">
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="ORIGINAL_VALUE@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.ORIGINAL_VALUE%>"/>
								</uix:column>

								<uix:column renderedBinding="NEW_VALUE_RENDERED@transactionDetailsListBean@servletRequest">
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="NEW_VALUE@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.NEW_VALUE%>"/>
								</uix:column>

	                    </uix:table>
						</uix:dataScope>                          
                    
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding ="TRANS_DETAILS_MESSAGE@arAdminMsgs"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
       </uix:document>          
 </uix:renderingContext>     