<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="TransactionInfoForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/transactionInfo"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                                             
                    <uix:spacer height="10" width="10"/>
                      
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout cellSpacing="10">
                          
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                    <uix:styledText textBinding="SOURCE@arAdminMsgs" styleClass="OraInstructionText"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                    <uix:messageTextInput name="id" textBinding="SOURCE@transactionInfoListBean@servletRequest" disabled="false" styleClass="OraDataText" readOnly="true"/>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>                              
                                <uix:cellFormat hAlign="right" vAlign="top">                                  
                                    <uix:styledText textBinding="START_TIME@arAdminMsgs" styleClass="OraInstructionText"/>
                                </uix:cellFormat>

                                <uix:cellFormat hAlign="left" vAlign="top">
                                    <uix:messageTextInput name="id" textBinding="START_TIME@transactionInfoListBean@servletRequest" disabled="false" styleClass="OraDataText" readOnly="true"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>

                        <uix:spacer height="10" width="10"/>


                        <uix:header textBinding="RPC@arAdminMsgs" styleClass="OraInstructionText">
                          
						<uix:dataScope currentDataBinding="transactionInfoListBean@servletRequest">
							<uix:table name="transactionInfoListTable" 
									alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
									formSubmitted="true"
									width="100%"
									tableDataBinding="rowData"
									minValue="1"
									valueBinding="startIndex"
									blockSizeBinding="blockTab" 
									maxValueBinding="numRows"
									shortDescBinding="TRANSACTION_INFO_LIST@arAdminMsgs"
									summaryBinding="TRANSACTION_INFO_LIST@arAdminMsgs" >

                              
								<uix:column>
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="TABLE@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.TABLE%>"/>
								</uix:column>

								<uix:column>
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="SCHEMA@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.SCHEMA%>"/>
								</uix:column>

								<uix:column>
								  <uix:columnHeader>
									<uix:sortableHeader sortable="no" textBinding="OPERATION@arAdminMsgs"/>
								  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="textFormat" />
									<uix:styledText textBinding="<%= ARAdminMsgID.OPERATION%>"/>
								</uix:column>

								<uix:tableSelection>
								  <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@arAdminMsgs">
										<uix:contents>
										   <uix:submitButton textBinding="DETAILS@arAdminMsgs" shortDescBinding="DETAILS@arAdminMsgs" name="event" value="viewTransactionDetails"/>
									</uix:contents>
								   </uix:singleSelection>
								</uix:tableSelection>

                            </uix:table>
						</uix:dataScope>
                        </uix:header>

                    
						<uix:pageStatus>
							<uix:formattedText renderedBinding="IS_DEFERRED_TRANSACTION@servletRequest" styleClass="OraInstructionText" textBinding="DEFERRED_TRANS_INFO_MESSAGE@arAdminMsgs"/>
							<uix:formattedText renderedBinding="IS_ERROR_TRANSACTION@servletRequest" styleClass="OraInstructionText" textBinding="ERROR_TRANS_INFO_MESSAGE@arAdminMsgs"/>                      
						</uix:pageStatus>
                    
					</uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
       </uix:document>          
 </uix:renderingContext>     