<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARAdminMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="arAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="TransactionsListForm" method="post" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/admin/transactionsList"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                                             
                    <uix:spacer height="10" width="10"/>

			<uix:dataScope currentDataBinding="transactionsListBean@servletRequest">
				<uix:table name="transactionsListTable" 
						alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
						formSubmitted="true"
						width="100%"
						tableDataBinding="rowData"
						minValue="1"
						valueBinding="startIndex"
						blockSizeBinding="blockTab" 
						maxValueBinding="numRows"
						shortDescBinding="TRANSACTIONS_LIST@arAdminMsgs"
						summaryBinding="TRANSACTIONS_LIST@arAdminMsgs" >


				<uix:column>
				  <uix:columnHeader>
				    <uix:sortableHeader sortable="no" textBinding="TRANSACTIONS_ID@arAdminMsgs"/>
				  </uix:columnHeader>
				    <uix:columnFormat columnDataFormat="textFormat" />
				    <uix:styledText textBinding="<%= ARAdminMsgID.TRANSACTIONS_ID%>"
									destinationBinding="TRANSACTIONS_ID_URL@transactionsListBean@servletRequest"/>
				</uix:column>

				<uix:column>
				  <uix:columnHeader>
				    <uix:sortableHeader sortable="no" textBinding="DESTINATION@arAdminMsgs"/>
				  </uix:columnHeader>
				    <uix:columnFormat columnDataFormat="textFormat" />
				    <uix:styledText textBinding="<%= ARAdminMsgID.DESTINATION%>"/>
				</uix:column>

				<uix:column>
				  <uix:columnHeader>
				    <uix:sortableHeader sortable="no" textBinding="START_TIME@arAdminMsgs"/>
				  </uix:columnHeader>
				    <uix:columnFormat columnDataFormat="textFormat" />
				    <uix:styledText textBinding="<%= ARAdminMsgID.START_TIME%>"/>
				</uix:column>

				<uix:column renderedBinding="IS_DEFERRED_TRANSACTION@servletRequest">
				  <uix:columnHeader>
				    <uix:sortableHeader sortable="no" textBinding="NUMBER_OF_CALLS@arAdminMsgs"/>
				  </uix:columnHeader>
				    <uix:columnFormat columnDataFormat="numberFormat" />
				    <uix:styledText textBinding="<%= ARAdminMsgID.NUMBER_OF_CALLS%>"/>
				</uix:column>

				<uix:column renderedBinding="IS_ERROR_TRANSACTION@servletRequest">
				  <uix:columnHeader>
				    <uix:sortableHeader sortable="no" textBinding="ERROR_MESSAGE@arAdminMsgs"/>
				  </uix:columnHeader>
				    <uix:columnFormat columnDataFormat="textFormat" />
				    <uix:styledText textBinding="<%= ARAdminMsgID.ERROR_MESSAGE%>"/>
				</uix:column>

				 <uix:tableSelection>
					  <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@arAdminMsgs">
					        <uix:contents>
							   <uix:submitButton renderedBinding="IS_ERROR_TRANSACTION@servletRequest" textBinding="RETRY@arAdminMsgs" shortDescBinding="RETRY@arAdminMsgs" name="event" value="retryErrorTransaction"/>
							   <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="REMOVE@dbMsgs" name="event" value="removeTransaction"/>
						</uix:contents>
					   </uix:singleSelection>
				 </uix:tableSelection>

			    </uix:table>
			</uix:dataScope>

			<uix:spacer height="10" width="10"/>
                        
                      
                    
                      <uix:pageStatus>
                        <uix:formattedText renderedBinding="IS_DEFERRED_TRANSACTION@servletRequest" styleClass="OraInstructionText" textBinding="DEFERRED_TRANSACTIONS_MESSAGE@arAdminMsgs"/>
                        <uix:formattedText renderedBinding="IS_ERROR_TRANSACTION@servletRequest" styleClass="OraInstructionText" textBinding="ERROR_TRANSACTIONS_MESSAGE@arAdminMsgs"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
  </uix:renderingContext>     

 