<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="adminRequests" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/masterGrp/adminRequests"/>
        <uix:formValue name="otype" valueBinding="otype@servletRequest"/>
        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
		 	 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="infos@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <!-- Search Section Start -->
			 <uix:spacer height="10" width="10"/>
				<uix:spacer height="10" width="10"/>
				
                                <uix:dataScope currentDataBinding="adminReqList@servletRequest">
								<uix:table name="adminReqList" 
								   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
								   formSubmitted="true"
								   width="100%"
								   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
								   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
								   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
								   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
								   shortDescBinding="header@servletRequest" 
								   summaryBinding="header@servletRequest">
                                      <uix:contents>
									  <uix:column>
									      <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="REQ@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:link  textBinding="request" destinationBinding="viewURL"/>
                                          </uix:contents>
                                        </uix:column>
										<uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="ID@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:text  textBinding="reqID"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="STATUS@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="status"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="SRC@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText  textBinding="source"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="USERID@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="userID"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="WHEN@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText  textBinding="when"/>
                                          </uix:contents>
                                        </uix:column>
 
                                      </uix:contents>
                                      <uix:tableSelection>
                                        <uix:multipleSelection shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" textBinding="TABLE_SELECTION@MasterGrpMsgs" selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>"/>
                                      </uix:tableSelection>
                                      <uix:tableActions>
                                        <uix:flowLayout>
                                          <uix:contents>
                                            <uix:tableLayout cellSpacing="3">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat>
                                                      <uix:contents>
                                                        <uix:messageChoice name="action" promptBinding="ACT@MasterGrpMsgs">
                                                          <uix:contents>
                                                            <uix:option textBinding="APPLY_LOCAL@MasterGrpMsgs" value="applyLocal" shortDescBinding="APPLY_LOCAL@MasterGrpMsgs" />
                                                            <uix:option textBinding="APPLY_ALL@MasterGrpMsgs" value="applyAll" shortDescBinding="APPLY_ALL@MasterGrpMsgs" renderedBinding="masterDefSite@defaultBean@servletRequest"/>
                                                            <uix:option textBinding="PURGE@MasterGrpMsgs" value="purge" shortDescBinding="PURGE@MasterGrpMsgs" />
                                                            <uix:option textBinding="REFRESH@MasterGrpMsgs" value="refresh" shortDescBinding="REFRESH@MasterGrpMsgs" />
                                                          </uix:contents>
                                                        </uix:messageChoice>
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat>
                                                      <uix:contents>
                                                        <uix:submitButton textBinding="GO@MasterGrpMsgs" name="event" value="applyAdminAction" shortDescBinding="GO@MasterGrpMsgs" />
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:tableLayout>
                                          </uix:contents>
                                        </uix:flowLayout>
                                      </uix:tableActions>
                                   </uix:table>
								</uix:dataScope>

					 <uix:spacer height="10" width="10"/>
					<uix:spacer height="10" width="10"/>
					<uix:tableLayout renderedBinding="masterDefSite@defaultBean@servletRequest" width="100%">
					<uix:rowLayout>
					<%-- <uix:tip>
                          <uix:contents>
                            <uix:formattedText textBinding="ADV_TEXT@MasterGrpMsgs"  />
                          </uix:contents>
                        </uix:tip> --%>
					</uix:rowLayout>
					<uix:rowLayout>
                        <uix:hideShow  id="hideShowAdvance" undisclosedTextBinding="ADV@MasterGrpMsgs" disclosedBinding="hideShow@defaultBean@servletRequest" disclosedTextBinding="ADV@MasterGrpMsgs"
						formSubmitted ="true">
                          <uix:contents>
                         <uix:header textBinding="DDL_TEXT@MasterGrpMsgs">
                          <uix:contents>
                            <uix:messageTextInput textBinding="ddlText@defaultBean@servletRequest" columns="70" name="ddlText" rows="5" shortDescBinding="DDL_TEXT@MasterGrpMsgs" labeledNodeId="hideShowAdvance"/>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="EXEC_AT@MasterGrpMsgs">
                          <uix:contents>
                             <uix:dataScope currentDataBinding="masterSiteList@servletRequest">
								<uix:table name="masterSiteList" 
								   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
								   formSubmitted="true"
								   width="100%"
								   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
								   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
								   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
								   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
								   shortDescBinding="EXEC_AT@MasterGrpMsgs" 
								   summaryBinding="EXEC_AT@MasterGrpMsgs">
                              <uix:contents>
                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:sortableHeader sortable="yes" textBinding="MASTER_SITE@MasterGrpMsgs"/>
                                  </uix:columnHeader>
                                  <uix:contents>
                                    <uix:styledText textBinding="dbLinkName"/>
                                  </uix:contents>
                                </uix:column>
                              </uix:contents>
                              <uix:tableSelection>
                                    <uix:multipleSelection shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" textBinding="TABLE_SELECTION@MasterGrpMsgs" selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>"/>
                            </uix:tableSelection>
                                <uix:tableActions>
                                    <uix:submitButton textBinding="EXEC@MasterGrpMsgs" name="event" value="executeAt" shortDescBinding="EXEC@MasterGrpMsgs" />
                                  </uix:tableActions>
                            </uix:table>
                            </uix:dataScope>
                          </uix:contents>
                        </uix:header>
                          </uix:contents>
                        </uix:hideShow>
				</uix:rowLayout>
			</uix:tableLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus>
              <uix:formattedText textBinding="ADMIN_REQ_INST_TEXT@MasterGrpMsgs" styleClass="OraInstructionText"/>
            </uix:pageStatus>
            <uix:pageButtons/>
            <!-- To add related links  -->
			<%--
            <uix:tableLayout>
              <uix:rowLayout width="20%">
                <uix:header textBinding="RELATED_LINK@ARSetupMsgs">
                  <uix:bulletedList>
                    <uix:link textBinding="MANAGEMENT@ARSetupMsgs" destination="QueueTablesURL@servletRequest"/>
                    <uix:link text="Master Groups Temporary Link" destination="/console/database/dist/advRepl/masterGroup"/>
                  </uix:bulletedList>
                  <uix:spacer height="5" width="10"/>
                </uix:header>
              </uix:rowLayout>
            </uix:tableLayout>
			--%>
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
