<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="masterGroupList" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/masterGrp/masterGroupList"/>
        <uix:formValue name="otype" valueBinding="otype@servletRequest"/>
        <uix:formValue name="from" valueBinding="from@servletRequest"/>
        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <!-- Search Section Start -->
			 <%--
			 <uix:spacer height="10" width="10"/>
                        <uix:header textBinding="SEARCH@MasterGrpMsgs">
                          <uix:contents>
                            <uix:tableLayout styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat width="9">
                                      <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:messageTextInput name="mgroupToSearch"
										textBinding="mgroupToSearch@servletRequest"
										promptBinding="NAME@ARSetupMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:spacer height="5" width="5"/>
                                        <uix:submitButton textBinding="GO@MasterGrpMsgs" name="event" value="search"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_TIP@MasterGrpMsgs"/>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:header>
			 <!-- Search Section End -->
				--%>
			         <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat  hAlign="right">
                                  <uix:contents>
                                    <uix:submitButton textBinding="CREATE@MasterGrpMsgs" 
									shortDescBinding="CREATE@MasterGrpMsgs" 
									name="event" value="create"/>
                                 </uix:contents>
                               </uix:cellFormat>
                             </uix:contents>
                           </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat  width="100%">
                                  <uix:contents>
								  <uix:dataScope currentDataBinding="masterGroupList@servletRequest">
								<uix:table name="masterGroupList" 
								   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs" 
								   formSubmitted="true"
								   width="100%"
								   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
								   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
								   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
								   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
								   shortDescBinding="MASTER_GROUPS_LIST@MasterGrpMsgs"  
								   summaryBinding="MASTER_GROUPS_LIST@MasterGrpMsgs">
							  <uix:contents>

							  <uix:column>
                                 <uix:columnHeader>
								   <uix:sortableHeader sortable="yes" textBinding="NAME@ARSetupMsgs" />
                                  </uix:columnHeader>
                                  <uix:contents>
									 <uix:link textBinding="grpName" shortDescBinding="NAME@ARSetupMsgs" destinationBinding="grpViewUrl"/>
                                   </uix:contents>
                                </uix:column>

							  <uix:column>
                                 <uix:columnHeader>
								   <uix:sortableHeader sortable="yes" textBinding="STATUS@MasterGrpMsgs" />
                                  </uix:columnHeader>
                                  <uix:contents>
                                          <uix:styledText textBinding="replicationStatus"/>
                                   </uix:contents>
                                </uix:column>

                           		<uix:column>
                                 <uix:columnHeader>
								   <uix:sortableHeader sortable="yes" textBinding="MASTER_DEF_SITE@MasterGrpMsgs" />
                                  </uix:columnHeader>
                                  <uix:contents>
                                          <uix:styledText textBinding="masterDefSite"/>
                                   </uix:contents>
                                </uix:column>

							  <uix:column>
                                 <uix:columnHeader>
							<uix:sortableHeader sortable="yes" textBinding="REP_OBJECT@MasterGrpMsgs" />
                                  </uix:columnHeader>
									<uix:columnFormat columnDataFormat="numberFormat"/>
                                  <uix:contents>
									 <uix:link textBinding="numReplicatedObj" destinationBinding="repObjectListUrl" disabledBinding="isRepObjExist" shortDescBinding="REP_OBJECT@MasterGrpMsgs" />
                                   </uix:contents>
                                </uix:column>

							  <uix:column>
                                 <uix:columnHeader>
							<uix:sortableHeader sortable="no" textBinding="ADM_REQ@MasterGrpMsgs" />
                                  </uix:columnHeader>
								  <uix:columnFormat columnDataFormat="numberFormat"/>
                                  <uix:contents>
                                             <uix:tableLayout>
                                                  <uix:contents>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
															  <uix:link textBinding="numAdminNormReq" 
															  disabledBinding="isNormReqExist"
															  shortDescBinding="NORMAL_REQ@MasterGrpMsgs"
															  destinationBinding="admReqUrl"/>
                                                         </uix:contents>
                                                       </uix:cellFormat>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:cellFormat renderedBinding="isErrReqExist">
                                                          <uix:contents>
															  <uix:link textBinding="numAdminErrReq" 
															  shortDescBinding="ERR_REQ@MasterGrpMsgs"
															  styleClass="OraErrorText"
															  destinationBinding="admErrReqUrl"/>
                                                         </uix:contents>
                                                       </uix:cellFormat>
                                                     </uix:contents>
                                                   </uix:rowLayout>
                                                 </uix:contents>
                                               </uix:tableLayout>
                                             </uix:contents>
                                </uix:column>
								
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:styledText textBinding="REP_ACTIVITY@MasterGrpMsgs"/>
                                         </uix:columnHeader>
											<uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                          <uix:contents>
                                            <uix:submitButton textBinding="replicationActivity" disabledBinding="isRepActityDisabled" 
											shortDescBinding="replicationActivity" 
											name="event" valueBinding="changeStatus"/>
                                         </uix:contents>
                                       </uix:column>
                          </uix:contents>
						   <uix:tableSelection>
                                     <uix:singleSelection shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" selectedIndex="0"/>
                            </uix:tableSelection>
							<uix:tableActions>
                                        <uix:flowLayout>
                                          <uix:contents>
                                            <uix:flowLayout>
                                              <uix:contents>
											  <uix:submitButton textBinding="EDIT@MasterGrpMsgs" name="event" 
													shortDescBinding="EDIT@MasterGrpMsgs" 
													value="editMG" renderedBinding="isRowAvailable"/>
												<uix:spacer height="10" width="10"/>
                                                <uix:submitButton textBinding="DELETE@MasterGrpMsgs" name="event" 
												  shortDescBinding="DELETE@MasterGrpMsgs" 
												  value="delete" renderedBinding="isRowAvailable"/>
                                             </uix:contents>
                                           </uix:flowLayout>
                                         </uix:contents>
                                       </uix:flowLayout>
                                     </uix:tableActions>
	                       </uix:table>
                        </uix:dataScope>

                                 </uix:contents>
                               </uix:cellFormat>
                             </uix:contents>
                           </uix:rowLayout>
                         </uix:contents>
                       </uix:tableLayout>
	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus>
              <uix:formattedText textBinding="MASTER_GRP_LIST_INST_TEXT@MasterGrpMsgs" styleClass="OraInstructionText"/>
            </uix:pageStatus>
            <uix:pageButtons/>
            <!-- To add related links  -->
			<%--
            <uix:tableLayout>
              <uix:rowLayout width="20%">
                <uix:header textBinding="RELATED_LINK@ARSetupMsgs">
                  <uix:bulletedList>
                    <uix:link textBinding="MANAGEMENT@ARSetupMsgs" destination="QueueTablesURL@servletRequest"/>
                    <uix:link text="Master Groups Temporary Link" destination="/console/database/dist/advRepl/masterGroup"/>
                  </uix:bulletedList>
                  <uix:spacer height="5" width="10"/>
                </uix:header>
              </uix:rowLayout>
            </uix:tableLayout>
			--%>
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
