<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="viewMG" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/masterGrp/viewMG"/>
        <uix:formValue name="otype" valueBinding="otype@servletRequest"/>
        <uix:formValue name="from" valueBinding="from@servletRequest"/>
        <uix:formValue name="grpName" valueBinding="grpName@defaultBean@servletRequest"/>
		<uix:formValue name="currStatus" valueBinding="replicationStatus@defaultBean@servletRequest"/>
		<uix:formValue name="isMasterDefSite" valueBinding="masterDefSite@defaultBean@servletRequest"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 
					<%-- General Section --%>
						<uix:header textBinding="GEN@MasterGrpMsgs">
                          <uix:contents>
                            <uix:tableLayout cellSpacing="5" styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat  hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="NAME@MasterGrpMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:styledText textBinding="grpName@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat  hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="CONN_QUAL@MasterGrpMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:styledText textBinding="linkQualifier@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat  hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="MASTER_DEF_SITE@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat  hAlign="left">
                                      <uix:contents>
                                        <uix:styledText textBinding="masterDefSite@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat  hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="STATUS@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat  hAlign="left">
                                      <uix:contents>
                                        <uix:styledText textBinding="replicationStatus@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat  hAlign="right" vAlign="top">
                                    <uix:contents>
                                      <uix:styledText textBinding="DESC@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat hAlign="left">
                                    <uix:contents>
											<%-- <uix:messageTextInput textBinding="description@defaultBean@servletRequest" styleClass="OraInstructionText" readOnly="true" rows="5" columns="70"/> --%>
                                        <uix:styledText textBinding="description@defaultBean@servletRequest" 
										styleClass="OraDataText"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                        </uix:contents>
                        </uix:header>

						<%-- Objects Section --%>
						<uix:header textBinding="OBJ@MasterGrpMsgs">
                          <uix:contents>
                              <uix:dataScope currentDataBinding="repObjectsList@servletRequest">
					              <uix:table name="repObjectsList" 
									alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs" 
									formSubmitted="true" width="100%" 
									valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
									maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>" 
									tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>" 
									blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
									shortDescBinding="MG_OBJECTS@MasterGrpMsgs" 
									summaryBinding="MG_OBJECTS@MasterGrpMsgs">
								<uix:contents>
								  <uix:column>
									<uix:columnHeader>
									  <uix:sortableHeader sortable="no" textBinding="NAME@ARSetupMsgs"/>
									</uix:columnHeader>
									<uix:contents>
									  <uix:styledText textBinding="oname"/>
									</uix:contents>
								  </uix:column>
								  <uix:column>
									<uix:columnHeader>
									  <uix:sortableHeader sortable="no" textBinding="SCHEMA@MasterGrpMsgs"/>
									</uix:columnHeader>
									<uix:contents>
									  <uix:styledText textBinding="sname"/>
									</uix:contents>
								  </uix:column>
								  <uix:column>
									<uix:columnHeader>
									  <uix:sortableHeader sortable="no" textBinding="TYPE@MasterGrpMsgs"/>
									</uix:columnHeader>
									<uix:contents>
									  <uix:styledText textBinding="otype"/>
									</uix:contents>
								  </uix:column>
								  <uix:column>
									<uix:columnHeader>
									  <uix:sortableHeader sortable="no" textBinding="STATUS@MasterGrpMsgs"/>
									</uix:columnHeader>
									<uix:contents>
									  <uix:styledText textBinding="status"/>
									</uix:contents>
								  </uix:column>
								<uix:column>
									<uix:columnHeader>
									  <uix:sortableHeader sortable="no" textBinding="GENSTATUS@MasterGrpMsgs"/>
									</uix:columnHeader>
									<uix:contents>
									  <uix:styledText textBinding="genstatus"/>
									</uix:contents>
								  </uix:column>
								</uix:contents>
								<uix:tableActions/>
								<uix:tableSelection/>
							  </uix:table>
				            </uix:dataScope>
                          </uix:contents>
                        </uix:header>
				

				<%-- Master Sites Section --%>
				<uix:header textBinding="MS@MasterGrpMsgs">
                          <uix:contents>
                               <uix:dataScope currentDataBinding="dbLinkList@servletRequest">
									 <uix:table name="dbLinkList" 
									   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs" 
									   formSubmitted="true"	   width="100%"
									   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
									   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
									   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
									   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
									   shortDescBinding="MS@MasterGrpMsgs"
									   summaryBinding="MS@MasterGrpMsgs">
                                        <uix:contents>
                                          <uix:column>
                                            <uix:columnHeader>
                                              <uix:sortableHeader sortable="no" textBinding="DBLINK@MasterGrpMsgs"/>
                                            </uix:columnHeader>
                                            <uix:contents>
                                              <uix:styledText textBinding="dbLinkName"/>
                                            </uix:contents>
                                          </uix:column>
									<%-- Table Contents END --%>
                                  </uix:contents>
                                        <uix:tableActions/>
                                        <uix:tableSelection/>
                                        <uix:footer/>
                                      </uix:table>
									  </uix:dataScope>

                          </uix:contents>
                        </uix:header>

					<uix:spacer height="10" width="10"/>
	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
	
				<uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="EDIT@MasterGrpMsgs" 
							shortDescBinding="EDIT@MasterGrpMsgs" 
							name="event" value="editMG"/>
                          </uix:contents>
                        </uix:pageButtonBar>
					</uix:pageButtons>

            <!-- To add related links  -->
			
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
