<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.MVGroupMsgID" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>      
      
        <uix:document>
        <%@ include file="/oemTitle.jspf"%>           
            <uix:body>
              
                <db:form name="AddObjectsForm" method="post" destination="/console/database/dist/advRepl/matViewGroup" 
				copyParams="target,type, objectType,otype, oname" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/mvgroup/addObjects"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
					<uix:formValue name="objectType" value="MATVIEW_GROUP"/>
					<uix:formValue name="otype" value="MATVIEW_GROUP"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>

					<uix:spacer height="10" width="10"/>
					<%-- Table data begin --%>
					<uix:dataScope currentDataBinding="addObjectsListBean@servletRequest">
					<uix:table name="addObjectsListTable" 
						alternateTextBinding="tableAlternateText"
						formSubmitted="true"
						width="100%"
						tableDataBinding="rowData"
						minValue="1"
						valueBinding="startIndex"
						blockSizeBinding="blockTab" 
						maxValueBinding="numRows"
						shortDescBinding="MVGROUP_OBJECTSLIST_TABLE@mvgroupsMsgs" 
						summaryBinding="MVGROUP_OBJECTSLIST_TABLE@mvgroupsMsgs">
								
							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="OBJECT_NAME@mvgroupsMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= MVGroupMsgID.OBJECT_NAME%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="SCHEMA@mvgroupsMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= MVGroupMsgID.SCHEMA%>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader sortable="no" textBinding="TYPE@mvgroupsMsgs"/>
							  </uix:columnHeader>
								<uix:columnFormat columnDataFormat="textFormat" />
								<uix:styledText textBinding="<%= MVGroupMsgID.TYPE%>"/>
							</uix:column>

							 <uix:tableSelection>
								  <uix:multipleSelection textBinding="TABLE_SELECTION@mvgroupsMsg" shortDescBinding="TABLE_SELECTION@mvgroupsMsgs" selectedBinding="selected"/>

							 </uix:tableSelection>

					</uix:table>
					</uix:dataScope>

					<%-- Table data end --%>
					 

					<uix:pageStatus>
						<uix:formattedText styleClass="OraInstructionText" textBinding="ADD_OBJECTS_MSG@mvgroupsMsgs"/>
					</uix:pageStatus>

				  
                      <uix:pageButtons>
                        <uix:pageButtonBar>                          
							<%--
							<uix:submitButton textBinding="OK@dbMsgs" 
							shortDescBinding="OK@dbMsgs" name="event" value="addObjects"/>
							<uix:submitButton textBinding="CANCEL@dbMsgs" 
							shortDescBinding="CANCEL@dbMsgs" name ="event" value ="cancelAddObjects"/>
							--%>
							<uix:submitButton textBinding="CONTINUE@dbMsgs" 
							shortDescBinding="CONTINUE@dbMsgs" name ="event" value ="continueAddObjects"/>

                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      </uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
</uix:renderingContext>     
