<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>


<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 

  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>      
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
        <uix:document>
		<%@ include file="/oemTitle.jspf"%>   
          <uix:contents>            
              <uix:body>
               <db:form name="customizeMVForm" method="post" 	          destination="/console/database/dist/advRepl/matViewGroup" 
				copyParams="target,type, objectType,otype, oname">

			   <uix:formValue name="pageName" value="/database/dist/advRepl/mvgroup/customizeMV"/>
               <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

                 
			  <uix:contents>
					
                   <uix:pageLayout styleClass="OraInstructionText" titleBinding="CUSTOMIZE_MV@mvgroupsMsgs">
						<!-- <%@ include file="/oemGlobal.jspf"%> -->
                        <%@ include file="/database/global.jspf" %>
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>
							<uix:text textBinding="cancelURL@servletRequest"/>
							<uix:tableLayout cellSpacing="10" rendered="false">
							<uix:rowLayout>
								<uix:cellFormat>
									<uix:styledText textBinding="CREATE_NEW_REFRESH_GROUP@mvgroupsMsgs" styleClass="OraInstructionText"/>
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:button name="storageClause" textBinding="CREATE@mvgroupsMsgs" onClick="alert('Work in Progress...')"/>
							</uix:cellFormat>
							</uix:rowLayout>
							</uix:tableLayout>
						
						<uix:spacer height="10" width="10"/>
						<uix:dataScope currentDataBinding="mviewsList@servletRequest">
						<uix:table name="mviewsList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
						   shortDescBinding="CUSTOMIZE_MV@mvgroupsMsgs" 
                           summaryBinding="CUSTOMIZE_MV@mvgroupsMsgs">
                        
						 <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="NAME@ARSetupMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText  textBinding="objectName" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>
                            
							<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="MVG_SCHEMA@ARSetupMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                     <uix:styledText  textBinding="schema" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="ROW_ID@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="rowID" checkedBinding="rowID" shortDescBinding="ROW_ID@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="MIN_COMM@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="mincommunication" checkedBinding="mincommunication" shortDescBinding="MIN_COMM@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="UPDATABLE@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="updatable"  checkedBinding="updatable" shortDescBinding="UPDATABLE@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>
							<uix:column>

                              <uix:columnHeader>
	                                <uix:styledText textBinding="FAST_REFRESH@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="fastRefresh" checkedBinding="fastRefresh" shortDescBinding="FAST_REFRESH@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="WHERE_CLAUSE@mvgroupsMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="whereClause" textBinding="whereClause" columns="50" rows="2" shortDescBinding="WHERE_CLAUSE@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="USE_STORAGE_CLAUSE@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                              <uix:contents>
								   <uix:submitButton name="event" textBinding="EDIT@mvgroupsMsgs" valueBinding="useStorageClause" shortDescBinding="EDIT@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>
							
							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="REFRESH_GROUPS@mvgroupsMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
		                        <oem:choice name="refreshGroup" optionsBinding="availableRefreshGroups" selectedValueBinding="refreshGroup" disabledBinding="refreshGrpNotAvailable" shortDescBinding="REFRESH_GROUPS@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>
							
							</uix:contents>

                          <uix:tableSelection/>
                          <uix:tableActions/>

						</uix:table>
						 </uix:dataScope>


						<uix:spacer height="10" width="10"/>
						 </uix:contents>
 
					 <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="BACK@dbMsgs" 
							shortDescBinding="BACK@dbMsgs" name ="event" value ="backToAddObjects"/>
							<uix:submitButton textBinding="CONTINUE@dbMsgs" 
							shortDescBinding="CONTINUE@dbMsgs" name ="event" value ="continueCustomizeMV"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
					
					 <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="CUST_MV_TEXT@ARSetupMsgs"/>
                      </uix:pageStatus>
                    
					
					</uix:pageLayout> 
					
				  </uix:contents>
                </db:form>
				</uix:body>
              </uix:contents>
		</uix:document>
</uix:renderingContext>
