<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.MVGroupMsgID" %>
<uix:renderingContext id="renderingContext">
	<%@ include file="/oemNoscript.jspf"%> 
    <db:script src="/database/utils.js"/>
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>

        <uix:document>
        <%@ include file="/oemTitle.jspf"%> 
          
            <uix:body>
              
                <db:form name="MVGroupsListForm" method="post" destination="/console/database/dist/advRepl/matViewGroup" copyParams="target,type, objectType,otype" >
                    <uix:formValue name="pageName" value="/database/dist/advRepl/mvgroup/mvgroupsList"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
					<uix:formValue name="otype" value="MATVIEW_GROUP"/>

                  <uix:pageLayout titleBinding="header@servletRequest">
                    
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>            
                    <%-- </uix:messages> --%>
                                             
                    <uix:spacer height="10" width="10"/>


			<uix:tableLayout width="100%">
				<uix:rowLayout hAlign="right">
					<uix:cellFormat>
						<uix:submitButton  textBinding="CREATE@dbMsgs" 
						shortDescBinding="CREATE@dbMsgs" name="event" value="onCreateMVG"/>
					</uix:cellFormat>
				</uix:rowLayout>

				<uix:rowLayout width="100%">
					<uix:dataScope currentDataBinding="mvgroupsListBean@servletRequest">                        
					<uix:table name="mvgroupsTable" 
							alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
							formSubmitted="true"
							width="100%"
							tableDataBinding="rowData"
							minValue="1"
							valueBinding="startIndex"
							blockSizeBinding="blockTab" 
							maxValueBinding="numRows"
							shortDescBinding="MVGROUPS_LIST_TABLE@mvgroupsMsgs"
							summaryBinding="MVGROUPS_LIST_TABLE@mvgroupsMsgs" >


						<uix:column>
						  <uix:columnHeader>
							<uix:sortableHeader sortable="no" textBinding="MATVIEW_GROUP@mvgroupsMsgs"/>
						  </uix:columnHeader>
							<uix:columnFormat columnDataFormat="textFormat" />
							<uix:styledText textBinding="<%= MVGroupMsgID.MATVIEW_GROUP%>"
								destinationBinding="MATVIEW_GROUP_URL@mvgroupsListBean@servletRequest" />
						</uix:column>

						 <uix:tableSelection>
							  <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@mvgroupsMsgs">
									<uix:contents>
									   <%-- <uix:submitButton textBinding="DELETE@dbMsgs" 
									   shortDescBinding="DELETE@dbMsgs" 
									   name="event" value="deleteMatGroup"/> --%>
										<uix:submitButton textBinding ="DELETE@dbMsgs"  
										shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
									   <uix:submitButton textBinding="EDIT@dbMsgs" shortDescBinding="EDIT@dbMsgs" 
									   name="event" value="edit"/>
								</uix:contents>
							   </uix:singleSelection>
						 </uix:tableSelection>

						</uix:table>
					</uix:dataScope>
					</uix:rowLayout>
				</uix:tableLayout>			

			<uix:spacer height="10" width="10"/>
                    
			  <uix:pageStatus>
				<uix:formattedText styleClass="OraInstructionText" textBinding="MATVIEW_GROUP_MSG@mvgroupsMsgs"/>
			  </uix:pageStatus>
			</uix:pageLayout>
                  
                </db:form>
              
            </uix:body>
          
        </uix:document>
  </uix:renderingContext>     

 
