<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
	  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>

	<uix:body>
      <!--  Form -->
      <uix:form name="addResolutionMethod" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/addResolutionMethod"/>
        <uix:formValue name="otype" value="REP_OBJ_TYPE"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
		
			
					<uix:spacer height="10" width="10"/>
                        <uix:tableLayout styleClass="OraInstructionText" cellSpacing="10">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:styledText textBinding="RES_METHODS@RepObjectMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                  <uix:contents>
								  <oem:choice name="updateMethods" 
											 optionsBinding="updateMethods@columnGrpListBean@servletRequest" 
											 shortDescBinding="selectedValue@servletRequest" 
											 selectedValueBinding="selectedValue@servletRequest"
											 onChange="submitForm('addResolutionMethod', true, {event:'methodsChanged'})"/>
											 
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                              <uix:rowLayout renderedBinding="isNotOverwrite@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:styledText textBinding="PARAM_COL@RepObjectMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                  <uix:contents>
									<oem:list name="paramColumnList" 
											shortDescBinding="PARAM_COL@RepObjectMsgs" 
											 optionsBinding="paramColumnList@columnGrpListBean@servletRequest"
											 size="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
							<uix:rowLayout renderedBinding="isNotUsrFunc@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:styledText textBinding="RES_USER_FUNC@RepObjectMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="userFunc"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                           
                          </uix:contents>
                        </uix:tableLayout>
				
						<%-- Priority Group Section --%>
						<uix:spacer height="10" width="10"/>
                        <uix:header textBinding="RES_PRIORGRP@RepObjectMsgs" renderedBinding="isNotPriorityGrp@servletRequest">
                        <uix:contents>
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:submitButton textBinding="CREATE@MasterGrpMsgs" name="event" value="createPriorGrp"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                   <uix:dataScope currentDataBinding="priorityGrpList@servletRequest">
											<uix:table name="priorityGrpList" 
											   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
											   formSubmitted="true"
											   width="100%"
											   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
											   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
											   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
											   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
											   shortDescBinding="RES_PRIORGRP@RepObjectMsgs" 
											   summaryBinding="RES_PRIORGRP@RepObjectMsgs">
                                      <uix:contents>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="NAME@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:link textBinding="priorityGrpName"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TYPE@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="priorityGrpType"/>
                                          </uix:contents>
                                        </uix:column>
                                      </uix:contents>
                                      <uix:tableSelection>
                                        <uix:singleSelection selectedIndex="0" 
										shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" 
										textBinding="TABLE_SELECTION@MasterGrpMsgs"/>
                                      </uix:tableSelection>
                                      <uix:tableActions>
                                        <uix:pageButtonBar>
                                          <uix:contents>
                                            <uix:submitButton textBinding="EDIT@MasterGrpMsgs" name="event" value="editPriorGrp" renderedBinding="isRowAvailable"/>
                                            <uix:submitButton textBinding="DELETE@MasterGrpMsgs" name="event" value="deletePriorGrp"	renderedBinding="isRowAvailable"/>
                                          </uix:contents>
                                        </uix:pageButtonBar>
                                      </uix:tableActions>
                                    </uix:table>
									</uix:dataScope>

                                  </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        </uix:contents>
                        </uix:header>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus>
				<uix:styledText textBinding="ADD_RES_INST_TEXT@RepObjectMsgs" styleClass="OraInstructionText"/>
			</uix:pageStatus>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="resMethodsTab"/>
                            <uix:submitButton textBinding="CONTINUE@ARSetupMsgs"  name="event" value="applyResMethod"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>

  </uix:document>
</uix:renderingContext>
