<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
	  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>

	<uix:body>
      <!--  Form -->
      <uix:form name="colGroupGenTab" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/colGroupGenTab"/>
        <uix:formValue name="otype" value="REP_OBJ_TYPE"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

				<uix:subTabLayout>
                         <uix:subTabs>
                            <uix:subTabBar styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:link textBinding="GEN@MasterGrpMsgs"
								onClick="submitForm('colGroupGenTab', true, {event:'editColGrp'})"
								selected="true"
								renderedBinding="editMode@columnGrpListBean@servletRequest"/>
                                <uix:link textBinding="RES_METHODS@RepObjectMsgs" 
								onClick="submitForm('colGroupGenTab', true, {event:'resMethodsTab'})"
								renderedBinding="editMode@columnGrpListBean@servletRequest"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
							
							<uix:tableLayout cellSpacing="5" renderedBinding="createMode@columnGrpListBean@servletRequest">
							<%-- Column Group Name Row --%>
							<uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messagePrompt promptBinding="COL_GRP_NAME@RepObjectMsgs" required="yes" labeledNodeId="groupName" />
                                  </uix:contents>
                                </uix:cellFormat>
								<uix:spacer height="10" width="10"/>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="groupName"  id="groupName" shortDescBinding="COL_GRP_NAME@RepObjectMsgs" textBinding="grpName@columnGrpListBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
							</uix:tableLayout>

							<%-- Available Columns/Selected Columns  --%>
							<uix:header textBinding="COLS@RepObjectMsgs">
									<oem:shuttle name="tableColumns" 
										  leadingHeaderBinding="AVAIL_COLS@RepObjectMsgs"
										  trailingHeaderBinding="SELECT_COLS@RepObjectMsgs" 
										  shortDescBinding="COLS@RepObjectMsgs" 
										  size="5"
										  reorderable="false">
											<uix:leading>
												 <oem:list name="currAvailableColumnsNames" shortDescBinding="AVAIL_COLS@RepObjectMsgs" 
				optionsBinding="currAvailableColumnsNames@columnGrpListBean@servletRequest"/>
										   </uix:leading>
										   <uix:trailing>
											 <oem:list name="currColumnsNames" shortDescBinding="SELECT_COLS@RepObjectMsgs" 
											 optionsBinding="currColumnsNames@columnGrpListBean@servletRequest"/>
										   </uix:trailing>
									  </oem:shuttle>
									 </uix:header>

									<uix:header textBinding="DESC@MasterGrpMsgs">
										<uix:messageTextInput name="description" rows="4" columns="80" textBinding="description@columnGrpListBean@servletRequest"  shortDescBinding="DESC@MasterGrpMsgs" 
										readOnlyBinding="editMode@columnGrpListBean@servletRequest"/>
									</uix:header>							

							<uix:spacer height="10" width="10"/>

							</uix:contents>			
                        </uix:subTabLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="confResTab"/>
                            <uix:submitButton textBinding="CONTINUE@ARSetupMsgs" name="event" value="applyColGrp"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>

  </uix:document>
</uix:renderingContext>
