<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
	  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>

	<uix:body>
      <!--  Form -->
      <uix:form name="colGroupResMethodsTab" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/colGroupResMethodsTab"/>
        <uix:formValue name="otype" value="REP_OBJ_TYPE"/>
        <uix:formValue name="editMode" valueBinding="editMode@columnGrpListBean@servletRequest"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


				<uix:subTabLayout>
                         <uix:subTabs>
                            <uix:subTabBar styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:link textBinding="GEN@MasterGrpMsgs"
								onClick="submitForm('colGroupResMethodsTab', true, {event:'editColGrp'})"								
								renderedBinding="editMode@columnGrpListBean@servletRequest"/>
                                <uix:link textBinding="RES_METHODS@RepObjectMsgs" 
								onClick="submitForm('colGroupResMethodsTab', true, {event:'resMethodsTab'})"
								renderedBinding="editMode@columnGrpListBean@servletRequest"
								selected="true"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
							<uix:rowLayout>
		                                <uix:formattedText textBinding="RES_METHODS_INSTR@RepObjectMsgs" styleClass="OraInstructionText"/>
                            </uix:rowLayout>
						
						 <uix:tableLayout width="100%">
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:submitButton textBinding="ADD@MasterGrpMsgs" name="event" value="addResMethod"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
							 <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="resolutionMethodsList@servletRequest">
											<uix:table name="resolutionMethodsList" 
											   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
											   formSubmitted="true"
											   width="100%"
											   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
											   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
											   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
											   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
											   shortDescBinding="REP_OBJ@RepObjectMsgs" 
											   summaryBinding="REP_OBJ@RepObjectMsgs">
                                      <uix:contents>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="METHOD@RepObjectMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="methodName"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="PARAM_COL@RepObjectMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="paramCol"/>
                                          </uix:contents>
                                        </uix:column>
										<%--
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="FUNC@RepObjectMsgs"/>
                                          </uix:columnHeader>
                                         <uix:contents>
                                            <uix:styledText textBinding="function"/>
                                          </uix:contents>
                                        </uix:column>
										--%>
                                      </uix:contents>
                                      <uix:tableSelection>
                                        <uix:singleSelection selectedIndex="0" textBinding="TABLE_SELECTION@MasterGrpMsgs" />
                                      </uix:tableSelection>
                                      <uix:tableActions>
                                        <uix:pageButtonBar>
                                          <uix:contents>
                                            <uix:submitButton textBinding="REMOVE@MasterGrpMsgs" name="event" value="removeResMethod" renderedBinding="isRowAvailable"/>
                                            <uix:messageChoice name="reorderOption" promptBinding="REORDER@RepObjectMsgs" renderedBinding="isRowAvailable">
                                              <uix:contents>
                                                <uix:option textBinding="MOVETOP@RepObjectMsgs" value="top"/>
                                                <uix:option textBinding="UP1@RepObjectMsgs" value="up1"/>
                                                <uix:option textBinding="DOWN1@RepObjectMsgs" value="down1"/>
                                                <uix:option textBinding="MOVEBOTTOM@RepObjectMsgs" value="bottom"/>
                                              </uix:contents>
                                            </uix:messageChoice>
                                            <uix:submitButton textBinding="GO@MasterGrpMsgs" renderedBinding="isRowAvailable" name="event" value="reorderMethods"/>
                                          </uix:contents>
                                        </uix:pageButtonBar>
                                      </uix:tableActions>
                                    </uix:table>
									</uix:dataScope>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
							</uix:tableLayout>

							</uix:contents>			
                        </uix:subTabLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="confResTab"/>
                            <uix:submitButton textBinding="CONTINUE@ARSetupMsgs" name="event" value="applyColGrp"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>

  </uix:document>
</uix:renderingContext>
