<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="columnSubsettingTab" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/columnSubsettingTab"/>
        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


				<uix:subTabLayout>
                         <uix:subTabs>
                            <uix:subTabBar styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:link textBinding="GEN@MasterGrpMsgs"
								onClick="submitForm('columnSubsettingTab', true, {event:'edit'})"/>
                                <uix:link textBinding="CONF_RES@RepObjectMsgs" 
	   							onClick="submitForm('columnSubsettingTab', true, {event:'confResTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest"/>
                                <uix:link textBinding="COL_SUB@RepObjectMsgs" 
								onClick="submitForm('columnSubsettingTab', true, {event:'colSubTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest" 								selected="true"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
						
						<uix:rowLayout>
						<uix:styledText textBinding="REP_OBJ_COLSUB_INST@RepObjectMsgs" styleClass="OraInstructionText"/>
						</uix:rowLayout>
						<uix:spacer height="10" width="10"/>


								<uix:dataScope currentDataBinding="colSubSettingList@servletRequest">
								<uix:table name="colSubSettingList" 
											   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
											   formSubmitted="true"
											   width="100%"
											   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
											   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
											   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
											   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
											   shortDescBinding="COL_SUB@RepObjectMsgs" 
											   summaryBinding="COL_SUB@RepObjectMsgs">
									  <uix:contents>
										<uix:column>
										  <uix:columnHeader>
											<uix:sortableHeader sortable="no" textBinding="COL_GRP@RepObjectMsgs"/>
										 </uix:columnHeader>
										  <uix:contents>
											<uix:text textBinding="colGrpName"/> 
										 </uix:contents>
									   </uix:column>
										<uix:column>
										  <uix:columnHeader>
											<uix:sortableHeader sortable="no" textBinding="COL@RepObjectMsgs"/>
										 </uix:columnHeader>
										  <uix:contents>
											<uix:text textBinding="column" /> 
										 </uix:contents>
									   </uix:column>
										<uix:column>
										  <uix:columnHeader>
											<uix:sortableHeader sortable="no" textBinding="TYPE@MasterGrpMsgs"/>
										 </uix:columnHeader>
										  <uix:contents>
											<uix:text textBinding="colType"/> 
										 </uix:contents>
									   </uix:column>
										<uix:column>
										  <uix:columnHeader>
											<uix:styledText textBinding="UPDATE@RepObjectMsgs"/>
										 </uix:columnHeader>
										  <uix:contents>
											<uix:messageCheckBox name="compareOnUpdate" disabledBinding="isPrimaryKey" checkedBinding="compareOnUpdate" shortDescBinding="UPDATE@RepObjectMsgs" />
										 </uix:contents>
									   </uix:column>
										<uix:column>
										  <uix:columnHeader>
											<uix:styledText textBinding="DELETE@RepObjectMsgs"/>
										 </uix:columnHeader>
										  <uix:contents>
											<uix:messageCheckBox name="compareOnDelete" disabledBinding="isPrimaryKey" checkedBinding="compareOnDelete" shortDescBinding="DELETE@RepObjectMsgs" />
										 </uix:contents>
									   </uix:column>
									 </uix:contents>
                               </uix:table>
								</uix:dataScope>

                                <uix:rowLayout>
                                  <uix:contents>
	                                  <uix:formattedText textBinding="SUB_SETTING_TIP@RepObjectMsgs" styleClass="OraInlineInfoText"/>
									</uix:contents>
								</uix:rowLayout>

							</uix:contents>			
                        </uix:subTabLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOW_SQL@ARSetupMsgs" name="event" value="showSql"/>
                            <uix:submitButton textBinding="REVERT@MasterGrpMsgs" name="event" value="revert"/>
                            <uix:submitButton textBinding="APPLY@MasterGrpMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
