<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="conflictResTab" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/conflictResTab"/>
        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


				<uix:subTabLayout>
                         <uix:subTabs>
                            <uix:subTabBar styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:link textBinding="GEN@MasterGrpMsgs"
								onClick="submitForm('conflictResTab', true, {event:'edit'})"/>
                                <uix:link textBinding="CONF_RES@RepObjectMsgs" 
	   							onClick="submitForm('conflictResTab', true, {event:'confResTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest" 								selected="true"/>
                                <uix:link textBinding="COL_SUB@RepObjectMsgs" 
								onClick="submitForm('conflictResTab', true, {event:'colSubTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
							
						<uix:styledText textBinding="REP_OBJ_CONFRES_INST@RepObjectMsgs" styleClass="OraInstructionText"/>
						<uix:spacer height="10" width="10"/>
							
							<uix:header textBinding="COL_GRP@RepObjectMsgs" styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:tableLayout width="100%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:submitButton  name="event" value="createColGrp"  textBinding="CREATE@MasterGrpMsgs"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                             <uix:dataScope currentDataBinding="columnGrpListBean@servletRequest">
											<uix:table name="columnGrpListBean" 
											   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
											   formSubmitted="true"
											   width="100%"
											   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
											   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
											   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
											   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
											   shortDescBinding="COL_GRP@RepObjectMsgs" 
											   summaryBinding="COL_GRP@RepObjectMsgs">
                                            <uix:contents>
                                              <uix:column>
                                                <uix:contents>
                                                  <uix:link textBinding="groupName"/> 
                                                </uix:contents>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader sortable="no" textBinding="NAME@MasterGrpMsgs"/>
                                                </uix:columnHeader>
                                              </uix:column>
                                            </uix:contents>
                                            <uix:tableSelection>
			                                     <uix:singleSelection shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" selectedIndex="0"/>
							                </uix:tableSelection>
                                            <uix:tableActions>
                                              <uix:pageButtonBar>
                                                <uix:contents>
	                                                 <uix:submitButton textBinding="EDIT@MasterGrpMsgs" name="event" value="editColGrp" renderedBinding="isRowAvailable"/>

	                                                 <uix:submitButton textBinding="REMOVE@MasterGrpMsgs" name="event" value="removeColGrp" renderedBinding="isRowAvailable"/>
                                                </uix:contents>
                                              </uix:pageButtonBar>
                                            </uix:tableActions>
                                          </uix:table>
										</uix:dataScope>

                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>

							</uix:contents>			
                        </uix:subTabLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOW_SQL@ARSetupMsgs" name="event" value="showSql"/>
                            <uix:submitButton textBinding="REVERT@MasterGrpMsgs" name="event" value="revert"/>
                            <uix:submitButton textBinding="APPLY@MasterGrpMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
