<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
	  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>

	<uix:body>
      <!--  Form -->
      <uix:form name="createPriorityGrp" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/createPriorityGrp"/>
        <uix:formValue name="otype" value="REP_OBJ_TYPE"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
					
		<uix:tableLayout styleClass="OraInstructionText" cellSpacing="10" width="100%">
				<uix:rowLayout>  
                        <uix:tableLayout styleClass="OraInstructionText" cellSpacing="10">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messagePrompt promptBinding="RES_PRIORGRP@RepObjectMsgs" required="yes" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="priorGrpName" id="priorGrpName" 
									textBinding="priorGrpName@priorityBean@servletRequest" 
									shortDescBinding="RES_PRIORGRP@RepObjectMsgs" 
									renderedBinding="createMode@priorityBean@servletRequest"/>

									<uix:styledText textBinding="priorGrpName@priorityBean@servletRequest"
									renderedBinding="editMode@priorityBean@servletRequest" styleClass="OraDataText"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:styledText textBinding="MASTER_GRP_NAME@RepObjectMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:styledText  textBinding="masterGroup@priorityBean@servletRequest" styleClass="OraDataText"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                              
                              <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:styledText textBinding="TYPE@MasterGrpMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
  									<uix:styledText textBinding="dataType@priorityBean@servletRequest" 
									renderedBinding="editMode@priorityBean@servletRequest" styleClass="OraDataText"/>

									 <oem:choice name="dataTypeList" 
											 optionsBinding="dataTypeList@priorityBean@servletRequest" 
											 shortDescBinding="dataType@priorityBean@servletRequest" 
											 selectedValueBinding="dataType@priorityBean@servletRequest"
											 onChange="submitForm('createPriorityGrp', true, {event:'dataTypeChanged'})"
											 readOnlyBinding="editMode@priorityBean@servletRequest"
											 renderedBinding="createMode@priorityBean@servletRequest"/>
									
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
						
							 <uix:rowLayout 	renderedBinding="isCharSelected@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                      <uix:messagePrompt promptBinding="ENT_LEN@RepObjectMsgs" required="yes" labeledNodeId="length" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
									 <uix:messageTextInput name="length" 	columns="10" id="length" 
									 shortDescBinding="ENT_LEN@RepObjectMsgs"  
									 textBinding="length@priorityBean@servletRequest">
										<uix:onBlurValidater>
                                            <uix:decimal maxScale="0"/>
                                        </uix:onBlurValidater>
									 </uix:messageTextInput>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
				</uix:rowLayout>  

				<uix:rowLayout width="100%">  
			    <uix:dataScope currentDataBinding="priorityValuesList@servletRequest">
											<uix:table name="priorityValuesList" 
											   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
											   formSubmitted="true"
											   width="25%"
											   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
											   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
											   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
											   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
											   shortDescBinding="PRIOR_VALUES@RepObjectMsgs" 
											   summaryBinding="PRIOR_VALUES@RepObjectMsgs">
                                      <uix:contents>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="PRIOR@RepObjectMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:tableLayout width="100%" cellSpacing="5">
											<uix:rowLayout>
											<uix:cellFormat hAlign="left" vAlign="bottom">

												<uix:messageTextInput name="priority" columns="15" shortDescBinding="PRIOR@RepObjectMsgs" textBinding="priority">
														<uix:onBlurValidater>
															<uix:decimal maxScale="0"/>
														</uix:onBlurValidater>
												</uix:messageTextInput>

											 </uix:cellFormat>
											 </uix:rowLayout>
                                            </uix:tableLayout>

                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="VAL@RepObjectMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:tableLayout width="100%" cellSpacing="5">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                <uix:contents>
												
    											  <uix:cellFormat hAlign="left" vAlign="bottom" renderedBinding="isNotDateType@servletRequest">
                                                    <uix:contents>
                                                      <uix:messageTextInput name="priorityVal" columns="15" 
													  shortDescBinding="VAL@RepObjectMsgs"
													  textBinding="priorityVal"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
				
                                                  <uix:cellFormat hAlign="left" vAlign="bottom" renderedBinding="isDateType@servletRequest">
                                                    <uix:contents>
													  <uix:messageDateField 
					                                      name="priorityVal" columns="15" 
														  shortDescBinding="VAL@RepObjectMsgs" 
					                                      valueBinding="priorityVal">                         
					                                      <uix:onSubmitValidater>
											                  <uix:date dateStyle="medium"/>
					                                    </uix:onSubmitValidater>
											           </uix:messageDateField>

                                                    </uix:contents>
                                                  </uix:cellFormat>

                                                </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                              </uix:tableLayout>
                                          </uix:contents>
                                        </uix:column>
                                      </uix:contents>
                                      <uix:tableActions>
                                        <uix:pageButtonBar>
                                          <uix:contents/>
                                        </uix:pageButtonBar>
                                      </uix:tableActions>
                                      <uix:columnFooter>
			                           <uix:submitButton textBinding="ADD5@ARSetupMsgs"
											  shortDescBinding="ADD5@ARSetupMsgs"
										  name="event"
										  value="add5more"/>
									   </uix:columnFooter>
                                    </uix:table>
									</uix:dataScope>
	                      </uix:rowLayout>  
						<uix:rowLayout>  
                        <uix:header textBinding="DESC@MasterGrpMsgs">
                          <uix:contents>
                            <uix:messageTextInput name="comment" rows="5" columns="80"  
							shortDescBinding="DESC@MasterGrpMsgs" textBinding="comment@priorityBean@servletRequest"/>
                          </uix:contents>
                        </uix:header>
					</uix:rowLayout>  
				</uix:tableLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus>
				<uix:styledText textBinding="CREATE_PRIOR_GRP_INST_TEXT@RepObjectMsgs" styleClass="OraInstructionText"/>
			</uix:pageStatus>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="addResMethod"/>
                            <uix:submitButton textBinding="OK@ARSetupMsgs"  name="event" value="applyPriorGrp"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>

  </uix:document>
</uix:renderingContext>
