<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="repObjectGenTab" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/repObjectGenTab"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


				<uix:subTabLayout>
                         <uix:subTabs>
                            <uix:subTabBar styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:link textBinding="GEN@MasterGrpMsgs"
								onClick="submitForm('repObjectGenTab', true, {event:'edit'})"
								selected="true" />
                                <uix:link textBinding="CONF_RES@RepObjectMsgs" 
	   							onClick="submitForm('repObjectGenTab', true, {event:'confResTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest"/>
                                <uix:link textBinding="COL_SUB@RepObjectMsgs" 
								onClick="submitForm('repObjectGenTab', true, {event:'colSubTab'})"
								renderedBinding="tableObj@defaultBean@servletRequest"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
					
						<uix:styledText textBinding="REP_OBJ_GENTAB_INST@RepObjectMsgs" styleClass="OraInstructionText"/>
				<uix:spacer height="10" width="10"/>
					<uix:tableLayout cellSpacing="10" styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="SCHEMA@MasterGrpMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
											<uix:styledText textBinding="sname@defaultBean@servletRequest" styleClass="OraDataText"/>
										</uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="TYPE@MasterGrpMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
											<uix:styledText textBinding="objType@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="STATUS@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
											<uix:styledText textBinding="status@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                
                                <uix:rowLayout renderedBinding="tableObj@defaultBean@servletRequest">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:styledText textBinding="GENSTATUS@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:styledText textBinding="generationStatus@defaultBean@servletRequest" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout renderedBinding="tableObjOrPackBody@defaultBean@servletRequest">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <%-- <uix:contents>
                                        <uix:styledText textBinding="GEN_REP_SUPPORT@MasterGrpMsgs" labeledNodeId="genRepSupport" styleClass="OraInstructionText"/>
                                      </uix:contents> --%> 
                                    </uix:cellFormat>
                                    <uix:cellFormat >
                                      <uix:contents>
                                        <uix:messageCheckBox name="genRepSupport" 
										textBinding="GEN_REP_SUPPORT@MasterGrpMsgs" 
										shortDescBinding="GEN_REP_SUPPORT@MasterGrpMsgs"  checkedBinding="genRepSupport@defaultBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                        <uix:styledText textBinding="DESC@MasterGrpMsgs" styleClass="OraInstructionText" labeledNodeId="description" />
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageTextInput name="description" rows="5" columns="80" id="description"
										textBinding="description@defaultBean@servletRequest" shortDescBinding="DESC@MasterGrpMsgs" />
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
							
							<%--  Advanced Option to execute DDL --%>
							<uix:hideShow  id="advanceHideShow" undisclosedTextBinding="ADV@MasterGrpMsgs" disclosedBinding="hideShow@defaultBean@servletRequest" disclosedTextBinding="ADV@MasterGrpMsgs"
							formSubmitted ="true">
                              <uix:contents>
                                <uix:header textBinding="DDL_TEXT@MasterGrpMsgs">
                                  <uix:contents>
                                    <uix:tableLayout>
                                    <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="ddlText" rows="6" columns="80" shortDescBinding="DDL_TEXT@MasterGrpMsgs" textBinding="ddlText@defaultBean@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        </uix:contents>
                                      </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:header>
                              </uix:contents>
                            </uix:hideShow>

							</uix:contents>			
                        </uix:subTabLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus/>
            <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOW_SQL@ARSetupMsgs" name="event" value="showSql"/>
                            <uix:submitButton textBinding="REVERT@MasterGrpMsgs" name="event" value="revert"/>
                            <uix:submitButton textBinding="APPLY@MasterGrpMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                     </uix:pageButtons>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
