<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="RepObjectMsgs" class="oracle.sysman.db.rsc.advRepl.RepObjectMsg"/>

  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
	<uix:body>
      <!--  Form -->
      <uix:form name="repObjectList" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/repObject/repObjectList"/>
        <uix:formValue name="grpName" valueBinding="grpName@servletRequest"/>
        <uix:formValue name="repStatus" valueBinding="repStatus@servletRequest"/>
        <uix:formValue name="otype" value="REP_OBJ_TYPE"/>

        <uix:contents>
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/oemGlobal.jspf"%>
            <uix:contents>
	         <!-- Page Layout Content (Start)-->
			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 
					<uix:spacer height="10" width="10"/>
					<uix:rowLayout>
						<uix:cellFormat>
							<uix:styledText textBinding="STATUS_MG@RepObjectMsgs" styleClass="OraInstructionText"/>
						</uix:cellFormat>
						<uix:spacer height="10" width="10"/>
						<uix:cellFormat>
							<uix:styledText textBinding="repStatus@servletRequest" styleClass="OraDataText"/>
						</uix:cellFormat>
						
					</uix:rowLayout>
					<uix:rowLayout>
						<uix:cellFormat>
							<uix:tip textBinding="EDIT_REP_OBJ_TIP@RepObjectMsgs"/>
						</uix:cellFormat>
					</uix:rowLayout>
					<uix:spacer height="10" width="10"/>

					<%--
				  <!-- Search Section Start -->
					<uix:spacer height="10" width="10"/>
                        <uix:header textBinding="SEARCH@MasterGrpMsgs">
                          <uix:contents>
                            <uix:tableLayout styleClass="OraInstructionText">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat width="9">
                                      <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:messageTextInput name="mgroupToSearch"
										textBinding="mgroupToSearch@servletRequest"
										promptBinding="NAME@MasterGrpMsgs" styleClass="OraInstructionText"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:spacer height="5" width="5"/>
                                        <uix:submitButton textBinding="GO@MasterGrpMsgs" name="event" value="search"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_TIP@MasterGrpMsgs"/>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:header>
					<!-- Search Section End -->
					--%>
							 <uix:spacer height="10" width="10"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="repObjectsList@servletRequest">
									<uix:table name="repObjectsList" 
								   alternateTextBinding="ALTERNATE_TEXT@MasterGrpMsgs"
								   formSubmitted="true"
								   width="100%"
								   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
								   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
								   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
								   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
								   shortDescBinding="header@servletRequest"
								   summaryBinding="header@servletRequest">
                                      <uix:contents>
                                        <uix:column>
                                          <uix:contents>
                                            <uix:styledText textBinding="oname"/>
                                          </uix:contents>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="NAME@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="SCHEMA@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="sname"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="TYPE@MasterGrpMsgs"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="otype"/>
                                          </uix:contents>
                                        </uix:column>
                                      </uix:contents>
                                      <uix:tableActions>
                                    <uix:flowLayout>
                                      <uix:contents>
                                        <uix:flowLayout>
                                          <uix:contents>
											         <uix:submitButton textBinding="EDIT@MasterGrpMsgs" name="event" 	value="edit" renderedBinding="isRemoveEnabled" disabledBinding="isEditDisabled@servletRequest"/>
										  </uix:contents>
                                        </uix:flowLayout>
                                      </uix:contents>
                                    </uix:flowLayout>
                                      </uix:tableActions>
                                      <uix:tableSelection>
				                         <uix:singleSelection shortDescBinding="TABLE_SELECTION@MasterGrpMsgs" selectedIndex="0"/>
			                           </uix:tableSelection>
                                    </uix:table>
									</uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>

	         <!-- Page Layout Content (End)-->
            </uix:contents>
            <uix:pageStatus>
              <uix:formattedText textBinding="REP_OBJ_LIST_INSTR_TEXT@RepObjectMsgs" styleClass="OraInstructionText"/>
            </uix:pageStatus>
            <uix:pageButtons/>
            <!-- To add related links  -->
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	</uix:body>
  </uix:document>
</uix:renderingContext>
