<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ include file="/oemNoscript.jspf"%>

<%
    request.setAttribute("arb", new BundleDataObject(NLSUtil.getBundle(ARSetupMsg.class.getName(), request)));    
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

        <uix:document>
          <%@ include file="/oemTitle.jspf" %>
          
          <uix:contents>
				<uix:body>      
                <uix:form name="addMasterSites" method="post">
                  <uix:formValue name="pageName" value="/database/dist/advRepl/setup/addMasterSites"/>
                  <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                  <uix:contents>
                    <uix:pageLayout titleBinding="header@servletRequest">
                     <%@ include file="/oemGlobal.jspf"%>
                      <uix:contents>
                        <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                        <uix:spacer height="10" width="10"/>
                         
                        <uix:dataScope currentDataBinding="masteSiteList@servletRequest">
                        <uix:table name="masterSiteList" 
                           alternateText="No Data Found"
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="MASTER_SITES_TAB@arb@servletRequest"
						   shortDescBinding="MASTER_SITES_TAB@arb@servletRequest">
                          <uix:contents>
                            <uix:column renderedBinding="isSiteVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="masterSite"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isHostVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="HOST@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="host"  textBinding="host" columns="20" shortDescBinding="HOST@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isPortVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="PORT@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="port"  textBinding="port" columns="20" shortDescBinding="PORT@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isSIDVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SID@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="sid"  textBinding="sid" columns="20" shortDescBinding="SID@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="USERNAME@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="userName" textBinding="SYSTEM@arb@servletRequest" disabled="true" columns="20" styleClass="OraDataText" readOnly="true"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="PASSWD@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="systemPasswd"  textBinding="systemPasswd" columns="20" secret="true"  noAutoComplete="true" shortDescBinding="PASSWD@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                          
                          <uix:columnFooter>
                           <uix:submitButton textBinding="ADD5@arb@servletRequest"
                              shortDescBinding="ADD5@arb@servletRequest"
                              name="event"
                              value="add5more"
                              renderedBinding="isAdd5RowsVisible@servletRequest"/>
                           </uix:columnFooter>
                           
                           <uix:tableSelection>
                            <uix:multipleSelection textBinding="TABLE_SELECTION@arb@servletRequest" selectedBinding="select" renderedBinding="isSelectionVisible@servletRequest"/>
                          </uix:tableSelection>
                          
                        </uix:table>
                        </uix:dataScope>

                        <uix:spacer height="10" width="10"/>


                      </uix:contents> <!-- End of PageLayout contents -->
                      
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@arb@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@arb@servletRequest"/>
                            <uix:navigationBar maxValue="7" formSubmitted="true" name="setupMSNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      <uix:location>
                            <uix:train value="1">
                              <uix:contents>
                <uix:link textBinding="ADD_MS@arb@servletRequest"/>
                <uix:link textBinding="CREATE_USERS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_LINKS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_PURGE@arb@servletRequest"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_EM_JOB@arb@servletRequest"/>
                <uix:link textBinding="REVIEW@arb"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>
                      
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="addMasterSitePageStatusText@servletRequest"/>
                      </uix:pageStatus>
                      
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
                        </uix:body>
          </uix:contents>
        </uix:document>
</uix:renderingContext>
