<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource"%>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
   <uix:bundle name="arb" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg" />
  <uix:dataScope currentDataBinding="defaultBean@servletRequest">
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:contents>
		<uix:body>
        <uix:form name="createUsers" method="post">
          <uix:formValue name="pageName" value="/database/dist/advRepl/setup/createUsers"/>
          <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
          <uix:contents>
            <uix:pageLayout titleBinding="header@servletRequest">
              <%@ include file="/oemGlobal.jspf"%>
              <uix:contents>
                 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                <uix:spacer height="10" width="10"/>
                <uix:header textBinding="ADMIN@arb">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:contents>
                                <uix:styledText textBinding="USERNAME@arb" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left" vAlign="top">
                              <uix:contents>
                                <uix:messageTextInput name="adminName" textBinding="adminName@defaultBean@servletRequest"  tipBinding="READMIN_TIP@arb" shortDescBinding="USERNAME@arb"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right" vAlign="top">
                            <uix:contents>
                              <uix:styledText textBinding="PASSWD@arb" styleClass="OraInstructionText"/>
                            </uix:contents>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="left" vAlign="top">
                            <uix:contents>
                              <uix:messageTextInput name="adminPasswd" secret="true" textBinding="adminPasswd@defaultBean@servletRequest" noAutoComplete="true" shortDescBinding="PASSWD@arb"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
            
              <uix:spacer height="10" width="10"/>
              <!-- Propagator List -->
                 <uix:spacer height="10" width="10"/>
                      <uix:header textBinding="PROPAGATOR@arb">
                        <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:styledText textBinding="PROPAGATOR_INST_TEXT@arb" styleClass="OraInstructionText"/>
                              </uix:contents>                                
                            </uix:rowLayout>   
                            <uix:spacer height="10" width="10"/>
                            <uix:rowLayout>
                              <uix:contents>
                                 <uix:tip textBinding="PROPAGATOR_INST_TIP@arb"/>
                              </uix:contents>                                
                            </uix:rowLayout>
                              
                        <uix:spacer height="10" width="10"/>

                        <uix:dataScope currentDataBinding="userList@servletRequest">
                        <uix:table name="userList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="PROP_TAB@arb"
						   shortDescBinding="PROP_TAB@arb">
                          <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="siteName"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="USERNAME@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="propUserName" textBinding="propUserName" readOnlyBinding="isDisabled" columns="20" tipBinding="propagatorTip" shortDescBinding="USERNAME@arb"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="PASSWD@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="propUserPasswd"  textBinding="propUserPasswd" columns="20" secret="true" noAutoComplete="true" shortDescBinding="PASSWD@arb"/>
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                        </uix:table>
                        </uix:dataScope>
                        
                        </uix:contents>
                        </uix:header>  
	          </uix:contents>
          <!-- End of PageLayout contents -->
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:contents>
                <uix:submitButton textBinding="CANCEL@arb" name="event" value="cancel" shortDescBinding="CANCEL@arb"/>
                <uix:navigationBar value="2" maxValue="7" formSubmitted="true" name="setupMSNavBar"/>
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:location>
            <uix:train value="2">
              <uix:contents>
                <uix:link textBinding="ADD_MS@arb"/>
                <uix:link textBinding="CREATE_USERS@arb"/>
                <uix:link textBinding="SCHED_LINKS@arb"/>
                <uix:link textBinding="SCHED_PURGE@arb"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb"/>
                <uix:link textBinding="SCHED_EM_JOB@arb"/>
                <uix:link textBinding="REVIEW@arb"/>
              </uix:contents>
            </uix:train>
          </uix:location>
          <uix:pageStatus>
            <uix:formattedText styleClass="OraInstructionText" textBinding="SETUP_MS_PAGE2_INST_TEXT@arb@servletRequest"/>
          </uix:pageStatus>
         </uix:pageLayout>
         </uix:contents>
        </uix:form>
      </uix:body>
    </uix:contents>
  </uix:document>
</uix:dataScope>  
</uix:renderingContext>
