<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource"%>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="arb"  class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:contents>
		<uix:body>
        <uix:form name="scheduleLinks" method="post">
          <uix:formValue name="pageName" value="/database/dist/advRepl/setup/scheduleLinks"/>
          <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
          <uix:contents>
            <uix:pageLayout titleBinding="header@servletRequest">
             <%@ include file="/oemGlobal.jspf"%>
              <uix:contents>
                    <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                       errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
                  <uix:header textBinding="DEFAULT@arb">
                  <!-- Default Scheduling -->
                  <%@ include file="defaultSchedule.jspf" %>
                  <uix:header textBinding="OPTIONS@arb">
                  <uix:tableLayout cellSpacing="5">
                     <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top">
                           <uix:styledText styleClass="OraInstructionText" textBinding="DELAY_SEC@arb"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="top">
                           <uix:messageTextInput name="delaySeconds"  textBinding="delaySeconds@defLinkSchedule@servletRequest" columns="5" tipBinding="DELAY_SEC_TIP@arb"
						   shortDescBinding="DELAY_SEC@arb">
                               <uix:onBlurValidater>
                                    <uix:decimal maxScale="0"/>
                               </uix:onBlurValidater>
                           </uix:messageTextInput>
                        </uix:cellFormat>
                     </uix:rowLayout>
                     <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top">
                           <uix:styledText styleClass="OraInstructionText" textBinding="STOP_ON_ERR@arb"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="top">
                           <uix:checkBox name="stopOnError" checkedBinding="stopOnError@defLinkSchedule@servletRequest"
						   shortDescBinding="STOP_ON_ERR@arb"/>
                        </uix:cellFormat>
                     </uix:rowLayout>
                     <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top">
                           <uix:styledText styleClass="OraInstructionText" textBinding="PROP_PROC@arb"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="top">
                           <uix:messageTextInput name="propagationProc" columns="5" textBinding="propagationProc@defLinkSchedule@servletRequest" tipBinding="PROP_PROC_TIP@arb"
						   shortDescBinding="PROP_PROC@arb">
                                <uix:onBlurValidater>
                                    <uix:decimal maxScale="0"/>
                               </uix:onBlurValidater>
                            </uix:messageTextInput>  
                        </uix:cellFormat>
                     </uix:rowLayout>
                  </uix:tableLayout>
                  </uix:header>
                  </uix:header>
                  
                  <%-- Customize section is visible for multi master environment --%>
                  <uix:header textBinding="CUST_INDV_SITE@arb" renderedBinding="multiMaster@defaultBean@servletRequest">
                     <uix:rowLayout>
                     <uix:styledText textBinding="CUST_INDV_SITE_INSTR@arb" styleClass="OraInstructionText"/>
                     </uix:rowLayout>
                     <uix:spacer height="10" width="10"/>              
                     
                     <uix:dataScope currentDataBinding="siteList@servletRequest">
                     <uix:table name="siteList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           allDetailsEnabledBinding="renderShowAllHideAllDetailsLinks"
                           detailDisclosureBinding="detailDisclosureList"
                           summaryBinding="CUST_SCH_LINK_TAB@arb"
						   shortDescBinding="CUST_SCH_LINK_TAB@arb">
                           
                          
                            <uix:detail>
                              <uix:tableLayout width="80%">
                                   <uix:rowLayout>

                                        <uix:cellFormat hAlign="left">
                                             <uix:rawText text="<pre>"/>
                                                  <uix:text   textBinding="customizeResult"/>
                                             <uix:rawText text="</pre>"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                   </uix:tableLayout>
                            </uix:detail>
                            
                            <uix:column>
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="siteName" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>
                           
                        <uix:tableActions>
                           <uix:submitButton textBinding="CUSTOMIZE@arb" name="event" value="customizeLink" shortDescBinding="CUSTOMIZE@arb"/>
                        </uix:tableActions>
                        <uix:tableSelection>
                           <uix:singleSelection selectedIndex="0"/>
                        </uix:tableSelection>
                     </uix:table>
                     </uix:dataScope>
                  </uix:header>
              </uix:contents>
               <!-- End of PageLayout contents -->
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:contents>
                <uix:submitButton textBinding="CANCEL@arb" name="event" value="cancel" shortDescBinding="CANCEL@arb"/>
                <uix:navigationBar value="3" maxValue="7" formSubmitted="true" name="setupMSNavBar"/>
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:location>
            <uix:train value="3">
              <uix:contents>
                <uix:link textBinding="ADD_MS@arb"/>
                <uix:link textBinding="CREATE_USERS@arb"/>
                <uix:link textBinding="SCHED_LINKS@arb"/>
                <uix:link textBinding="SCHED_PURGE@arb"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb"/>
                <uix:link textBinding="SCHED_EM_JOB@arb"/>
                <uix:link textBinding="REVIEW@arb"/>
              </uix:contents>
            </uix:train>
          </uix:location>
          <uix:pageStatus>
            <uix:formattedText styleClass="OraInstructionText" textBinding="SETUP_MS_PAGE3_INST_TEXT@arb"/>
          </uix:pageStatus>
         </uix:pageLayout>
         </uix:contents>
        </uix:form>
      </uix:body>
    </uix:contents>
  </uix:document>

</uix:renderingContext>
