<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="ARAdminMsgs" class="oracle.sysman.db.rsc.advRepl.ARAdminMsg"/>
  <!-- Document -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:contents>
		<uix:body>
      <!--  Form -->
      <uix:form name="showSetupOptions" method="post">
        <uix:formValue name="pageName" value="/database/dist/advRepl/setup/showSetupOptions"/>
        <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
        <uix:contents>
          <!-- Page Layout -->
          <uix:pageLayout titleBinding="header@servletRequest">

            <%@ include file="/database/global.jspf" %>
            <uix:contents>
			<!-- Error Message -->
			<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

			<oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
              <!-- Main contents -->
			  <%--
              <uix:spacer height="10" width="10"/>
              <uix:header textBinding="OPTIONS@ARSetupMsgs">
                <uix:contents>
                  <uix:tableLayout>
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MS@ARSetupMsgs" selected="true" value="setupMS"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right">
                            <uix:contents>
                              <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="EXPLAIN_STEPS_MS@ARSetupMsgs"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
					   
					   <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MG@ARSetupMsgs" value="createMG"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPLAIN_STEPS_MG@ARSetupMsgs"/>
                        </uix:contents>
                      </uix:rowLayout>


                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVS@ARSetupMsgs" value="configureMV"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageStyledText textBinding="EXPLAIN_STEPS_MVS@ARSetupMsgs" styleClass="OraInlineInfoText"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_DT@ARSetupMsgs" value="createTemplate"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPLAIN_STEPS_DT@ARSetupMsgs"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVG@ARSetupMsgs" value="createMVG"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPLAIN_STEPS_MVG@ARSetupMsgs"/>
                        </uix:contents>
                      </uix:rowLayout>


                    </uix:contents>
                  </uix:tableLayout>
                </uix:contents>
              </uix:header>
			--%>

				<uix:tableLayout cellSpacing="10">
					<uix:rowLayout>
						<uix:cellFormat vAlign="top" hAlign="left">
								<uix:spacer height="10" width="10"/>
								<uix:hideShow  id="mmHideShow" undisclosedTextBinding="MM_HEADER@ARSetupMsgs" 				disclosedBinding="mmHideShow@servletRequest" 
								disclosedTextBinding="MM_HEADER@ARSetupMsgs"
								formSubmitted ="true">
										  <uix:contents>
												<uix:spacer height="10" width="10"/>
												<uix:styledText textBinding="MM_INST_TEXT@ARSetupMsgs" styleClass="OraInlineInfoText"/>
												<uix:rowLayout>
												<uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MS@ARSetupMsgs" selected="true" value="setupMS"/>
												</uix:rowLayout>
												<uix:rowLayout>
													<uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MG@ARSetupMsgs" value="createMG"/>
												</uix:rowLayout>
										  </uix:contents>
								 </uix:hideShow>

								<uix:spacer height="10" width="10"/>
								<uix:hideShow  id="umvHideShow" undisclosedTextBinding="UMV_HEADER@ARSetupMsgs"
								disclosedBinding="umvHideShow@servletRequest" 
								disclosedTextBinding="UMV_HEADER@ARSetupMsgs"
								formSubmitted ="true">
										  <uix:contents>
												<uix:spacer height="10" width="10"/>
												<uix:styledText textBinding="UMV_INST_TEXT@ARSetupMsgs" styleClass="OraInlineInfoText"/>
												<uix:spacer height="10" width="10"/>
												<uix:rowLayout>
													<uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MS@ARSetupMsgs" selected="true" value="setupMS"/>
												</uix:rowLayout>
												<uix:rowLayout>
													  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVS@ARSetupMsgs" value="configureMV"/>
												</uix:rowLayout>
												<uix:rowLayout>
													  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVG@ARSetupMsgs" value="createMVG"/>
												</uix:rowLayout>
												<uix:rowLayout>
														  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVL@ARSetupMsgs" value="createMVL"/>
												</uix:rowLayout>
												<uix:rowLayout>
														  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MV@ARSetupMsgs" value="createMV"/>
												</uix:rowLayout>
										  </uix:contents>
								 </uix:hideShow>

								<uix:spacer height="10" width="10"/>
								 <uix:hideShow  id="rmvHideShow" undisclosedTextBinding="RMV_HEADER@ARSetupMsgs" 				disclosedBinding="rmvHideShow@servletRequest" 
								disclosedTextBinding="RMV_HEADER@ARSetupMsgs"
								formSubmitted ="true">
										  <uix:contents>
												<uix:rowLayout>
														  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MVL@ARSetupMsgs" value="createMVL" selected="true"/>
												</uix:rowLayout>
												<uix:rowLayout>
														  <uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_MV@ARSetupMsgs" value="createMV"/>
												</uix:rowLayout>
										  </uix:contents>
								 </uix:hideShow>

								<uix:spacer height="10" width="10"/>
								 <uix:hideShow  id="tempHideShow" undisclosedTextBinding="DEPTEMPL_HEADER@ARSetupMsgs" 				disclosedBinding="tempHideShow@servletRequest" 
								disclosedTextBinding="DEPTEMPL_HEADER@ARSetupMsgs"
								formSubmitted ="true">
										  <uix:contents>
												<uix:rowLayout>
													<uix:messageRadioButton name="setupOptions" textBinding="SETUP_OPTION_DT@ARSetupMsgs" value="createTemplate" selected="true"/>
												</uix:rowLayout>
										  </uix:contents>
								 </uix:hideShow>
						</uix:cellFormat>
						<%--
						<uix:cellFormat vAlign="top" hAlign="right">
								<uix:contentContainer background="light" rendered="true" textBinding="ADV_REPL_SETUP_OPTIONS@ARSetupMsgs" width="70%">                                      
                                        <uix:stackLayout rendered="true">
                                          
                                            <uix:rowLayout>
                                                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="SETUP_CONTENT_TEXT@ARSetupMsgs"/>
                                            </uix:rowLayout>
										</uix:stackLayout>
									</uix:contentContainer>
						</uix:cellFormat>
						--%>
					</uix:rowLayout>
				</uix:tableLayout>


            </uix:contents>
            <uix:pageStatus>
              <uix:formattedText textBinding="SETUP_INFO@ARSetupMsgs" styleClass="OraInstructionText"/>
            </uix:pageStatus>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel" shortDescBinding="CANCEL@ARSetupMsgs"/>
                  <uix:submitButton textBinding="CONTINUE@ARSetupMsgs" name="event" value="continue" shortDescBinding="CONTINUE@ARSetupMsgs"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>
            <!-- To add related links  -->
			<uix:spacer height="10" width="10"/>
            <uix:tableLayout>
              <uix:rowLayout width="20%">
                <uix:header textBinding="RELATED_LINK@ARSetupMsgs">
                  <uix:bulletedList>
                    <db:link textBinding="AR_MANAGEMENT@ARSetupMsgs" destination="/console/database/dist/advRepl/advReplicationAdmin" copyParams="target,type"/>
                  </uix:bulletedList>
                  <uix:spacer height="5" width="10"/>
                </uix:header>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
	  </uix:body>
    </uix:contents>
  </uix:document>
</uix:renderingContext>
