<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ include file="/oemNoscript.jspf"%>

<%
    request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
    request.setAttribute("arb", new BundleDataObject(NLSUtil.getBundle(ARSetupMsg.class.getName(), request)));    
%>

  <uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
	<uix:document>
    <%@ include file="/oemTitle.jspf"%>   
	      
              <uix:contents>
                <uix:body>
				<uix:form name="addMSAndMVSites" method="post">
                  
				   <uix:formValue name="pageName" value="/database/dist/advRepl/setupmv/addMSAndMVSites"/>
                   <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>			  
				
				  <uix:contents>
				  
				   <uix:pageLayout titleBinding="header@servletRequest">
                     <%@ include file="/oemGlobal.jspf"%>
                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                       
					   <uix:contents>
                        <uix:spacer height="10" width="10"/>

						<uix:header textBinding="SETUP_MV_STEP1_MASTERSITE@arb@servletRequest">
                          <uix:contents>
                            <uix:formattedText textBinding="SETUP_MV_STEP1_MSHEADERTEXT@arb@servletRequest"
							 styleClass="OraInstructionText"/>


						<uix:dataScope currentDataBinding="masterSiteList@servletRequest">
                        <uix:table name="masterSiteList" 
                           alternateText="No Data Found"
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="MASTER_SITES_TAB@arb@servletRequest"
						   shortDescBinding="MASTER_SITES_TAB@arb@servletRequest">
                          <uix:contents>
                            <uix:column renderedBinding="isSiteVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="masterSite"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isHostVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_HOST@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="host"  textBinding="host" columns="20" shortDescBinding="SETUP_MV_STEP1_HOST@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isPortVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_PORT@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="port"  textBinding="port" columns="20" shortDescBinding="SETUP_MV_STEP1_PORT@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isSIDVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_SID@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="sid"  textBinding="sid" columns="20" shortDescBinding="SETUP_MV_STEP1_SID@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_USERNAME@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="userName" textBinding="SYSTEM@arb@servletRequest" disabled="true" columns="20" styleClass="OraDataText" readOnly="true"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_PASSWORD@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="systemPasswd"  textBinding="systemPasswd" columns="20" secret="true" noAutoComplete="true" shortDescBinding="SETUP_MV_STEP1_PASSWORD@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                          
                           <uix:tableSelection>
                            <uix:singleSelection textBinding="TABLE_SELECTION@arb@servletRequest" selectedBinding="select" renderedBinding="isSelectionVisible@servletRequest">
							<primaryClientAction>
							<fireAction source="masterSiteList" event="event2"> </fireAction> 
							<firePartialAction name="event1" targets="masterSiteList" source="masterSiteList" event="event" unvalidated="true" />
							</primaryClientAction>
							</uix:singleSelection>
                          </uix:tableSelection>
                          
                        </uix:table>
                        </uix:dataScope>

                          </uix:contents>
                        </uix:header>

                        <uix:header textBinding="SETUP_MV_STEP1_MVSITE@arb@servletRequest">
                          <uix:contents>
                            <uix:formattedText textBinding="SETUP_MV_STEP1_MVHEADERTEXT@arb@servletRequest" styleClass="OraInstructionText"/>

						<uix:dataScope currentDataBinding="mvSiteList@servletRequest">					
                         <uix:table name="mvSiteList" 
                           alternateText="No Data Found"
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="MVS_TAB@arb@servletRequest"
						   shortDescBinding="MVS_TAB@arb@servletRequest">
                          <uix:contents>
                            <uix:column renderedBinding="isSiteVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="masterSite"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isHostVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_HOST@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="host"  textBinding="host" columns="20" shortDescBinding="SETUP_MV_STEP1_HOST@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isPortVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_PORT@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="port"  textBinding="port" columns="20" shortDescBinding="SETUP_MV_STEP1_PORT@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column renderedBinding="isSIDVisible@servletRequest">
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_SID@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="sid"  textBinding="sid" columns="20" shortDescBinding="SETUP_MV_STEP1_SID@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                            
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_USERNAME@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="userName" textBinding="SYSTEM@arb@servletRequest" disabled="true" columns="20" styleClass="OraDataText" readOnly="true"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="SETUP_MV_STEP1_PASSWORD@arb@servletRequest"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="systemPasswd"  textBinding="systemPasswd" columns="20" secret="true" noAutoComplete="true" shortDescBinding="SETUP_MV_STEP1_PASSWORD@arb@servletRequest"/>
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                          
                          <uix:columnFooter>
                           <uix:submitButton textBinding="ADD5@sb@servletRequest"
                              shortDescBinding="ADD5@sb@servletRequest"
                              name="event"
                              value="add5more"
                              renderedBinding="isAdd5RowsVisible@servletRequest"/>
                           </uix:columnFooter>
                           
                           <uix:tableSelection>
                            <uix:multipleSelection textBinding="TABLE_SELECTION@arb@servletRequest" selectedBinding="select" renderedBinding="isSelectionVisible@servletRequest"/>
                          </uix:tableSelection>
                          
                        </uix:table>
                        </uix:dataScope>
												
						</uix:contents>
                        </uix:header>                                          
                      </uix:contents>

                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="CANCEL@arb@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@arb@servletRequest"/>
							<uix:navigationBar maxValue="7" formSubmitted="true" name="setupMVNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					  <uix:location>
                            <uix:train value="1">
                              <uix:contents>
                <uix:link textBinding="ADD_MS_MV@arb@servletRequest"/>
                <uix:link textBinding="CREATE_USERS@arb@servletRequest"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_LINKS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_PURGE@arb@servletRequest"/>
                <uix:link textBinding="SCHED_EM_JOB@arb@servletRequest"/>
                <uix:link textBinding="REVIEW@arb"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>


					  <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="addMasterSitePageStatusText@servletRequest"/>
                      </uix:pageStatus>

                      </uix:pageLayout>
                  </uix:contents>
                </uix:form>
			</uix:body>
          </uix:contents>
        </uix:document>

</uix:renderingContext>
