
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource"%>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ include file="/oemNoscript.jspf"%>
<%
    request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
    request.setAttribute("arb", new BundleDataObject(NLSUtil.getBundle(ARSetupMsg.class.getName(), request)));    
%>

<uix:renderingContext id="renderingContext">
<uix:bundle name="arb" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg" />
   <uix:bundle name="sb" class="oracle.sysman.db.rsc.streams.StrmSetupMsg" />

  <oem:setURLEncoder id="renderingContext"/>
  
  
  <uix:dataScope currentDataBinding="defaultBean@servletRequest">
	
	  <uix:document>
          <%@ include file="/oemTitle.jspf"%>    
		 
              <uix:contents>
				<uix:body>
                <uix:form name="createUsers" method="post">
				<uix:formValue name="pageName" value="/database/dist/advRepl/setupmv/createUsers"/>
				<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

					 <uix:contents>

					 <uix:pageLayout titleBinding="header@servletRequest">
                     <%@ include file="/oemGlobal.jspf"%>
					 
                       <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                       <uix:contents>

                        <uix:header textBinding="ADMIN@arb" styleClass="OraInstructionText">
                          <uix:contents>                          
							<uix:tableLayout cellSpacing="5">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="UN@sb" styleClass="OraInstructionText" 
										required="yes"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                        <uix:messageTextInput name="adminName" textBinding="adminName@defaultBean@servletRequest"  
										tipBinding="AD_TIP@arb" shortDescBinding="UN@sb"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="PWD@sb" styleClass="OraInstructionText" 
										required="yes"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                        <uix:messageTextInput name="adminPasswd" secret="true" textBinding="adminPasswd@defaultBean@servletRequest" noAutoComplete="true" shortDescBinding="PWD@sb"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                                           
                              </uix:contents>
                            </uix:tableLayout>


                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageCheckBox name="usePropogator" text=" Use same administrator schema and password for all propagators and receivers" checked="false" rendered="false"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:spacer height="10" width="10"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:tip rendered="false">
                                  <uix:contents>
                                    <uix:formattedText text="There can be only one propagator or receiver registered to a single Materialized View site" rendered="false"/>
                                  </uix:contents>
                                </uix:tip>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:header>

						
					<%-- Proxy user at Master site --%>
                        <uix:header textBinding="PROXY_MS_USER@arb" styleClass="OraInstructionText">
                          <uix:contents>                          
							<uix:tableLayout cellSpacing="5">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="UN@sb" styleClass="OraInstructionText" 
										required="yes"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                        <uix:messageTextInput name="proxyMasterSiteUsername" 
										textBinding="proxyMasterSiteUsername@defaultBean@servletRequest"  
										shortDescBinding="UN@sb"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="PWD@sb" styleClass="OraInstructionText" 
										required="yes" />
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                        <uix:messageTextInput name="proxyMS_Pwd" secret="true" 
										textBinding="proxyMasterSitePwd@defaultBean@servletRequest" noAutoComplete="true" 
										shortDescBinding="PWD@sb"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>                                                           
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>

					<%-- Proxy user END--%>

                        <uix:header textBinding="PROPAGATOR@arb" styleClass="OraInstructionText">
                          <uix:contents>
                            <uix:messageStyledText textBinding="PROP_HEAD@arb" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                 <uix:styledText textBinding="PROPAGATOR_INST_TIP@arb" styleClass="OraInstructionText"/>
                              </uix:contents>                                
                            </uix:rowLayout>

                        <uix:dataScope currentDataBinding="userList@servletRequest">
                        <uix:table name="userList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="PROP_TAB@arb"
						   shortDescBinding="PROP_TAB@arb">
                          <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="siteName"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="UN@sb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="propUserName" textBinding="propUserName" readOnlyBinding="isDisabled" columns="20" tipBinding="propagatorTip" shortDescBinding="UN@sb"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="PWD@sb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="propUserPasswd"  textBinding="propUserPasswd" columns="20" secret="true" noAutoComplete="true" shortDescBinding="PWD@sb" />
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                        </uix:table>
                        </uix:dataScope>

                          </uix:contents>
                        </uix:header>
                      </uix:contents>

                      
                      <uix:pageStatus>
                        <uix:formattedText textBinding="USER_HEAD@arb"  styleClass="OraInstructionText"/>
                      </uix:pageStatus>
                      
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                             <uix:submitButton textBinding="CANCEL@arb@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@arb@servletRequest"/>
                            <uix:navigationBar value="2" maxValue="7" formSubmitted="true" name="setupMVNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					   <uix:location>
                            <uix:train value="2">
                              <uix:contents>
                <uix:link textBinding="ADD_MS_MV@arb@servletRequest"/>
                <uix:link textBinding="CREATE_USERS@arb@servletRequest"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_LINKS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_PURGE@arb@servletRequest"/>
                <uix:link textBinding="SCHED_EM_JOB@arb@servletRequest"/>
                <uix:link textBinding="REVIEW@arb@servletRequest"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>

                      </uix:pageLayout>
                  </uix:contents>
                </uix:form>
             </uix:body>
          </uix:contents>
        </uix:document>
</uix:dataScope>  
</uix:renderingContext>
