<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource"%>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ include file="/oemNoscript.jspf"%>
<%
    request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
    request.setAttribute("arb", new BundleDataObject(NLSUtil.getBundle(ARSetupMsg.class.getName(), request)));    
%>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="arb"  class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
 <uix:bundle name="ScheduleBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

         <uix:document>
          <%@ include file="/oemTitle.jspf"%>   
            
           
         
              <uix:contents>

                 <uix:form name="schedulePurge" method="post">
<uix:formValue name="pageName" value="/database/dist/advRepl/setupmv/schedulePurge"/>
<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
              
		  <uix:contents>
                    <uix:pageLayout titleBinding="header@servletRequest">
                      <%@ include file="/oemGlobal.jspf"%>

						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

					   <uix:contents>
                            <uix:spacer height="10" width="10"/>


					<uix:dataScope currentDataBinding="purgeScheduleList@servletRequest">
                        <uix:table name="purgeScheduleList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="PURG_TAB@arb@servletRequest"
						   shortDescBinding="PURG_TAB@arb@servletRequest">
                          <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="yes" textBinding="SITE@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText textBinding="siteName" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="START_DATE@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                 <uix:messageDateField 
                                      name="startDate"
                                      valueBinding="startDate"
                                      shortDescBinding="START_DATE@ScheduleBundle">                         
                                      <uix:onSubmitValidater>
                                      <uix:date dateStyle="medium"/>
                                    </uix:onSubmitValidater>
                               </uix:messageDateField>
                              </uix:contents>
                            </uix:column>
                            
                           <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="TIME@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                 <uix:rowLayout>
                                       <uix:cellFormat>
                                       <%-- START HOUR --%>
                                       <oem:choice 
                                         name="startHR"
                                         optionsBinding="hours"
                                         shortDescBinding="HOURS@scheduleBundle"
                                         selectedValueBinding="startHR"/>
                                      </uix:cellFormat>
                                      <uix:spacer height="5" width="5"/>
                                      <uix:cellFormat>
                                     <%-- START MINUTE --%>
                                       <oem:choice 
                                            name="startMIN"
                                            optionsBinding="minutes"
                                            shortDescBinding="MINUTES@scheduleBundle"
                                            selectedValueBinding="startMIN"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <uix:cellFormat>
                                     <%-- START SECOND --%>
                                       <oem:choice 
                                            name="startSEC"
                                            optionsBinding="seconds"
                                            shortDescBinding="SECONDS@scheduleBundle"
                                            selectedValueBinding="startSEC"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <%-- START AM/PM --%>
                                       <uix:cellFormat>
                                          <oem:radioButton
                                               name="startAmPm" 
                                               value="AM_VALUE"
                                               selectedValueBinding="startAmPm"
                                               textBinding="AM_LABEL@ScheduleBundle"
                                               styleClass="OraInstructionText"/>
                                       </uix:cellFormat>
                                       <uix:spacer height="5" width="5"/>
                                       <uix:cellFormat>
                                          <oem:radioButton 
                                               name="startAmPm" 
                                               value="PM_VALUE"
                                               selectedValueBinding="startAmPm"
                                               textBinding="PM_LABEL@ScheduleBundle"
                                               styleClass="OraInstructionText"/>
                                       </uix:cellFormat>
                                 </uix:rowLayout>      
                              </uix:contents>
                            </uix:column>

                            <uix:column>
                              <uix:columnHeader>
                                <uix:sortableHeader sortable="no" textBinding="INTERVAL@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                 <uix:rowLayout>
									<%--
									<uix:cellFormat>
										<uix:styledText textBinding="EVERY@arb@servletRequest" labeledNodeId="intv" styleClass="OraInstructionText"/>
									</uix:cellFormat>
									--%>
                                    <uix:cellFormat>
                                       <uix:messageTextInput name="repeatFrequency" textBinding="repeatFrequency" columns="5" shortDescBinding="EVERY@arb@servletRequest">
                                          <uix:onSubmitValidater>
                                             <uix:decimal maxScale="0"/>
                                          </uix:onSubmitValidater>
                                       </uix:messageTextInput>
                                    </uix:cellFormat>
                                    <uix:spacer height="5" width="5"/>
                                    <uix:cellFormat>
                                    <%-- START Intervals --%>
                                    <oem:choice 
                                      name="intervals"
                                      optionsBinding="intervals"
                                      shortDescBinding="INTERVAL@scheduleBundle"
                                      selectedValueBinding="repeatInterval"/>

                                </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:column>
                            
                              <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="DELAY_SEC@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                 <uix:messageTextInput name="delaySecond" textBinding="delaySecond" columns="5" shortDescBinding="DELAY_SEC@arb@servletRequest">
                                    <uix:onSubmitValidater>
                                       <uix:decimal maxScale="0"/>
                                    </uix:onSubmitValidater>
                                 </uix:messageTextInput>

                              </uix:contents>
                            </uix:column>

                              <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="ROLLBACK_SEG@arb"/>
                              </uix:columnHeader>
                              <uix:contents>
                                    <oem:choice 
                                      name="rollBackSegment"
                                      optionsBinding="segments"
                                      selectedValueBinding="rollBackSegment"/>
                              </uix:contents>
                            </uix:column>

                          </uix:contents>
                        </uix:table>
                        </uix:dataScope>



                       <uix:spacer height="10" width="10"/>
                     
			    </uix:contents>
                     
                      
                    
                      
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                         <uix:submitButton textBinding="CANCEL@arb@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@arb@servletRequest"/>
                            <uix:navigationBar value="5" maxValue="7" formSubmitted="true" name="setupMVNavBar" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
					
					 <uix:location>
                            <uix:train value="5">
                              <uix:contents>
                <uix:link textBinding="ADD_MS_MV@arb@servletRequest"/>
                <uix:link textBinding="CREATE_USERS@arb@servletRequest"/>
                <uix:link textBinding="CREATE_SCHEMAS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_LINKS@arb@servletRequest"/>
                <uix:link textBinding="SCHED_PURGE@arb@servletRequest"/>
                <uix:link textBinding="SCHED_EM_JOB@arb@servletRequest"/>
                <uix:link textBinding="REVIEW@arb"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>
						 <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="SETUP_MV_PAGE5_INST_TEXT@arb@servletRequest"/>
                      </uix:pageStatus>
                      </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
           
        </uix:document>

</uix:renderingContext>

		





		
                      


