<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>

      <uix:document>
	     <%@ include file="/oemTitle.jspf"%>
		  <uix:body>
               <uix:form name="addObjects" method="post">
			   <uix:formValue name="pageName" value="/database/dist/advRepl/setupmvg/addObjects"/>
               <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
				<uix:contents>
               <uix:pageLayout styleClass="OraInstructionText" titleBinding="MVG_AO_HEAD@ARSetupMsgs">
						<%@ include file="/oemGlobal.jspf"%>                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
					  <uix:contents>                        
						<uix:spacer height="10" width="10"/>
							<uix:tableLayout cellSpacing="10">
							<uix:rowLayout>
								<uix:cellFormat>
									<uix:styledText textBinding="MASTER_GRP@ARSetupMsgs" styleClass="OraInstructionText"/>
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:styledText textBinding="masterGroup@defaultBean@servletRequest" styleClass="OraDataText"/>
								</uix:cellFormat>
							</uix:rowLayout>
							</uix:tableLayout>
                            <uix:header textBinding="MASTER_GROUP_OBJECTS@mvgroupsMsgs">
									
									<uix:dataScope currentDataBinding="masterGroupObjectList@servletRequest">
						<uix:table name="masterGroupObjectList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
						   shortDescBinding="MASTER_GROUP_OBJECTS@mvgroupsMsgs" 
                           summaryBinding="MASTER_GROUP_OBJECTS@mvgroupsMsgs">

								  <uix:contents>
                                    
									<uix:column>
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="NAME@ARSetupMsgs"/>
                                      </uix:columnHeader>
                                      <uix:contents>
                                <uix:messageTextInput name="objectName" textBinding="objectName" columns="20" readOnly="true"/>
                                <uix:formValue name="objectName" valueBinding="objectName"/>
                              </uix:contents>
                                    </uix:column>
                                    
									<uix:column>
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="MVG_SCHEMA@ARSetupMsgs"/>
                                      </uix:columnHeader>
                                       <uix:contents>
                                <uix:messageTextInput name="schema" textBinding="schema" columns="20" readOnly="true"/>
                                <uix:formValue name="schema" valueBinding="schema"/>
                              </uix:contents>
                                    </uix:column>
                                  
									
									<uix:column>
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="MVG_TYPE@ARSetupMsgs"/>
                                      </uix:columnHeader>
                                      <uix:contents>
                                <uix:messageTextInput name="type" textBinding="type" columns="20" readOnly="true"/>
                                <uix:formValue name="type" valueBinding="type"/>
                              </uix:contents>
                                    </uix:column>
                                  
								  
								  </uix:contents>
                                  <uix:tableSelection>
                                   <uix:multipleSelection shortDescBinding="TABLE_SELECTION@mvgroupsMsgs"  selectedBinding="<%= UIXDataSource.S_SELECT_ATTR%>"/>
                                  </uix:tableSelection>
                                  <uix:tableActions>
                                    <uix:flowLayout>
                                      <uix:contents/>
                                    </uix:flowLayout>
                                  </uix:tableActions>
                                </uix:table>
								 </uix:dataScope>
 </uix:header>
                      
					  </uix:contents>
					  
					  <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel"/>
							<uix:navigationBar value="3" maxValue="6" formSubmitted="true" name="setupTemplateNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					  <uix:location>
                            <uix:train value="3">
                              <uix:contents>
							    
								<uix:link textBinding="MVG_TR_GEN@ARSetupMsgs"/>
								<uix:link textBinding="MVG_TR_SELMG@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_AO@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_MVC@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_EMJOB@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_REV@ARSetupMsgs"/>

                            </uix:contents>
                            </uix:train>
                      </uix:location>
                      
					  <uix:pageStatus>
                        <uix:formattedText textBinding="MVG_AO_STAT@ARSetupMsgs" styleClass="OraInstructionText"/>
                      </uix:pageStatus>

                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
           
      </uix:body>
        </uix:document>

</uix:renderingContext>

