<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>

        <uix:document>
		<%@ include file="/oemTitle.jspf"%>   
          <uix:contents>            
              <uix:body>
               <uix:form name="customizeMV" method="post">
			   <uix:formValue name="pageName" value="/database/dist/advRepl/setupmvg/customizeMV"/>
               <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                 
			  <uix:contents>
					
                   <uix:pageLayout styleClass="OraInstructionText" titleBinding="MVG_MVC_HEAD@ARSetupMsgs">
						<%@ include file="/oemGlobal.jspf"%>
                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>

							<uix:spacer height="10" width="10"/>
							<uix:tableLayout cellSpacing="10" rendered="false">
							<uix:rowLayout>
								<uix:cellFormat>
									<uix:styledText textBinding="CREATE_NEW_REFRESH_GROUP@mvgroupsMsgs" styleClass="OraInstructionText"/>
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:button name="storageClause" textBinding="CREATE@mvgroupsMsgs" onClick="alert('Work in Progress...')"/>
							</uix:cellFormat>
							</uix:rowLayout>
							</uix:tableLayout>
								<uix:spacer height="10" width="10"/>

							<uix:header textBinding="MATERIALIZED_VIEWS@mvgroupsMsgs">
						<uix:dataScope currentDataBinding="mviewsList@servletRequest">
						<uix:table name="mviewsList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
						   shortDescBinding="MATERIALIZED_VIEWS@mvgroupsMsgs" 
                           summaryBinding="MATERIALIZED_VIEWS@mvgroupsMsgs">
                        
						 <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="NAME@ARSetupMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:styledText  textBinding="objectName" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>
                            
							<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="MVG_SCHEMA@ARSetupMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                     <uix:styledText  textBinding="schema" styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="ROW_ID@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="rowID" checkedBinding="rowID" shortDescBinding="ROW_ID@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="MIN_COMM@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="mincommunication" checkedBinding="mincommunication" shortDescBinding="MIN_COMM@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="UPDATABLE@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="updatable"  checkedBinding="updatable" shortDescBinding="UPDATABLE@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>
							<uix:column>

                              <uix:columnHeader>
	                                <uix:styledText textBinding="FAST_REFRESH@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                              <uix:contents>
                                <uix:messageCheckBox name="fastRefresh" checkedBinding="fastRefresh" shortDescBinding="FAST_REFRESH@mvgroupsMsgs" />
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="WHERE_CLAUSE@mvgroupsMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput shortDescBinding="WHERE_CLAUSE@mvgroupsMsgs" name="whereClause" textBinding="whereClause" columns="50" rows="2"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="USE_STORAGE_CLAUSE@mvgroupsMsgs"/>
                              </uix:columnHeader>
							  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                              <uix:contents>
		                               <%-- <uix:link name="storageClause" text="Edit" destinationBinding="editStorageClause"/> --%>
									   <uix:submitButton name="event" textBinding="EDIT@@mvgroupsMsgs" valueBinding="useStorageClause"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
	                                <uix:styledText textBinding="REFRESH_GROUPS@mvgroupsMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
		                        <oem:choice name="refreshGroup" optionsBinding="availableRefreshGroups" 
								shortDescBinding="REFRESH_GROUPS@mvgroupsMsgs" 
								selectedValueBinding="refreshGroup" disabledBinding="refreshGrpNotAvailable"/>
								
								<%--
								<uix:messageChoice name="refreshGroup">
									<uix:option text="Refresh Group1"/>
									<uix:option text="Refresh Group2"/>
									<uix:option text="Refresh Group3"/>
									<uix:option text="Refresh Group4"/>
								</uix:messageChoice>
								--%>
                              </uix:contents>
                            </uix:column>
							</uix:contents>

                          <uix:tableSelection/>
                          <uix:tableActions/>

						</uix:table>
						 </uix:dataScope>
						</uix:header>
						<uix:spacer height="10" width="10"/>
						 </uix:contents>
 
					 <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel"/>
							<uix:navigationBar value = "4" maxValue="6" formSubmitted="true" name="setupTemplateNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					  <uix:location>
                            <uix:train value="4">
                              <uix:contents>
							    
								<uix:link textBinding="MVG_TR_GEN@ARSetupMsgs"/>
								<uix:link textBinding="MVG_TR_SELMG@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_AO@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_MVC@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_EMJOB@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_REV@ARSetupMsgs"/>

                            </uix:contents>
                            </uix:train>
                      </uix:location>

					
					 <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="CUST_MV_TEXT@ARSetupMsgs"/>
                      </uix:pageStatus>
                    
					
					</uix:pageLayout> 
					
				  </uix:contents>
                </uix:form>
				</uix:body>
              </uix:contents>
		</uix:document>
</uix:renderingContext>
