<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>


<uix:renderingContext id="renderingContext">

  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="mvgroupsMsgs" class="oracle.sysman.db.rsc.advRepl.MVGroupMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
        <uix:document>
		<%@ include file="/oemTitle.jspf"%>   
          <uix:contents>            
              <uix:body>
               <db:form name="general" method="post" destination="/console/database/dist/advRepl/createMVG" copyParams="target,type,fromMVGAdmin">
			   <uix:formValue name="pageName" value="/database/dist/advRepl/setupmvg/general"/>
               <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                 
			  <uix:contents>

                   <uix:pageLayout styleClass="OraInstructionText" titleBinding="MVG_GEN_HEAD@ARSetupMsgs">
						<%@ include file="/oemGlobal.jspf"%>
                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>
						 
						 <uix:spacer height="10" width="10"/>
						 <uix:tableLayout cellSpacing="5">
							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:messageStyledText required="yes" textBinding="LINK_TO_MASTER@mvgroupsMsgs" styleClass="OraInstructionText"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
									<uix:messageLovField name="masterSite" 
									textBinding="masterSite@defaultBean@servletRequest" 
									shortDescBinding="LINK_TO_MASTER@mvgroupsMsgs" 
									searchDescBinding="LINK_TO_MASTER@mvgroupsMsgs" 
									onClick = "startLov('masterSite', 'ListLinks')"/>
								</uix:cellFormat>
							</uix:rowLayout>
							<uix:rowLayout>
								<uix:cellFormat>
									<uix:styledText textBinding="PROPAGATION_MODE@mvgroupsMsgs" styleClass="OraInstructionText"/>
								</uix:cellFormat>
								<uix:cellFormat>
									<oem:radioButton 
                                 name="propMode"
                                 value="Asynchronous"
                                 selectedValueBinding="propMode@defaultBean@servletRequest"
                                 textBinding="MVG_ASYN@ARSetupMsgs" 
								 shortDescBinding="MVG_ASYN@ARSetupMsgs"
                                 styleClass="OraInstructionText"/>

								  <oem:radioButton 
                                 name="propMode" 
                                 value="Synchronous"
                                 selectedValueBinding="propMode@defaultBean@servletRequest"
                                 textBinding="MVG_SYN@ARSetupMsgs" 
								 shortDescBinding="MVG_SYN@ARSetupMsgs"
                                 styleClass="OraInstructionText"/>
								</uix:cellFormat>
							</uix:rowLayout>
						 </uix:tableLayout>
						

						

						<%-- End of PageLayout Contents --%>
						</uix:contents>
 					 <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel"/>
							<uix:navigationBar value="1" maxValue="6" formSubmitted="true" name="setupTemplateNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					  <uix:location>
                            <uix:train value="1">
                              <uix:contents>
							    
								<uix:link textBinding="MVG_TR_GEN@ARSetupMsgs"/>
								<uix:link textBinding="MVG_TR_SELMG@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_AO@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_TR_MVC@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_EMJOB@ARSetupMsgs"/>
                                <uix:link textBinding="MVG_REV@ARSetupMsgs"/>

                            </uix:contents>
                            </uix:train>
                      </uix:location>

					
					 <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="CREATE_MVG_STEP1_MSG@mvgroupsMsgs"/>
                      </uix:pageStatus>
					
					</uix:pageLayout>
					
				  </uix:contents>
                </db:form>
				</uix:body>
              </uix:contents>
		</uix:document>
</uix:renderingContext>
