<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="TemplateMsgs" class="oracle.sysman.db.rsc.advRepl.TemplateMsg"/>

	<uix:document>
	 <%@ include file="/oemTitle.jspf"%>   
	  <uix:contents>	
		<uix:body>
		<uix:form name="admintemplate" method="post">
		  <uix:formValue name="pageName" value="/database/dist/advRepl/tempadmin/admintemplate"/>
		  <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>			  
		  <uix:contents>
                    
		    <uix:pageLayout styleClass="OraInstructionText" titleBinding="header@servletRequest">
			
		     <%@ include file="/oemGlobal.jspf"%>

			 <oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
			 <oem:messageBox messageType = "info" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                <uix:contents>
                       <uix:spacer height="10" width="10"/>
				       <uix:tableLayout width="100%">

							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
										 <uix:submitButton textBinding="CREATE@MasterGrpMsgs" name="event" value="create" shortDescBinding="CREATE@MasterGrpMsgs"/>
								</uix:cellFormat>
							</uix:rowLayout>

                            <uix:rowLayout>
								<uix:cellFormat>
										<%-- Table --%>
									<uix:dataScope currentDataBinding="adminList@servletRequest">  
									  <uix:table name="adminList" 
									   formSubmitted="true"
									   width="100%"
									   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
									   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
									   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
									   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
									   summaryBinding="messageAlterText"
									   shortDescBinding="DEP_TABL_DESC@TemplateMsgs">
									  
									  <uix:contents>                                    									
										
										<uix:column>
										  <uix:columnHeader>
											<uix:sortableHeader sortable="no" textBinding="NAME@MasterGrpMsgs"/>
										  </uix:columnHeader>
											<uix:columnFormat columnDataFormat="textFormat" />
											<uix:styledText textBinding="objectName"
												destinationBinding="Template_URL@adminList@servletRequest" />
										</uix:column>
										
										 <uix:column >
										  <uix:columnHeader>
											<uix:styledText textBinding="OWNER@TemplateMsgs"/>
										  </uix:columnHeader>
										  <uix:contents>
											<uix:messageTextInput name="ownerName" textBinding="ownerName" columns="20" readOnly="true"/>
											<uix:formValue name="ownerName" valueBinding="ownerName"/>
										  </uix:contents> 
										</uix:column>

										<uix:column >
										  <uix:columnHeader>
											<uix:styledText textBinding="PUBLIC@TemplateMsgs"/>
										  </uix:columnHeader>
										  <uix:contents>
											<uix:messageTextInput name="isPub" textBinding="isPub" columns="20" readOnly="true"/>
											<uix:formValue name="isPub" valueBinding="isPub"/>
										  </uix:contents> 
										</uix:column>

										<uix:column >
										  <uix:columnHeader>
											<uix:styledText textBinding="INST@TemplateMsgs"/>
										  </uix:columnHeader>
										  <uix:contents>
											<uix:messageTextInput name="isIns" textBinding="isIns" columns="20" readOnly="true"/>
											<uix:formValue name="isIns" valueBinding="isIns"/>
										  </uix:contents> 
										</uix:column>
										
										<uix:column >
										  <uix:columnHeader>
											<uix:styledText textBinding="EDIT@MasterGrpMsgs"/>
										  </uix:columnHeader>
										  <uix:contents>
												<uix:image source="/em/images/updateicon_enabled.gif" shortDescBinding="EDIT@MasterGrpMsgs"
												destinationBinding="Template_EDITURL@adminList@servletRequest"/>
										  </uix:contents> 
										</uix:column>

									  </uix:contents>
									  
									  <uix:tableSelection>
										<uix:multipleSelection textBinding="TABLE_SELECTION@ARSetupMsgs" selectedBinding="select" />
									  </uix:tableSelection>
									  
									  <uix:tableActions>
									  			<uix:rowLayout renderedBinding="isRowAvailable">
													  <uix:contents>
														<uix:cellFormat>
														  <uix:contents>
															<uix:rowLayout>
															  <uix:contents>
																
																<uix:spacer height="10" width="10"/>
																<uix:cellFormat>
																  <uix:contents>
																  <uix:submitButton textBinding="DELETE@MasterGrpMsgs" name="event" value="delete" shortDescBinding="DELETE@MasterGrpMsgs"/>
																  </uix:contents>
																</uix:cellFormat>
																<uix:spacer height="10" width="10"/>
																<uix:cellFormat>
																	<uix:styledText textBinding="ACT@MasterGrpMsgs" styleClass="OraInstructionText"/>
																</uix:cellFormat>
																<uix:spacer height="5" width="5"/>
																<uix:cellFormat>
																  <uix:contents>
																	<uix:messageChoice name="templateAction">
																	  <uix:contents>
																		<uix:option textBinding="COPY@TemplateMsgs" value="Copy"/>
																		<uix:option textBinding="COMPARE@TemplateMsgs" value="Compare"/>
																		<uix:option textBinding="GENSCRIPT@TemplateMsgs" value="SCRIPT_GEN"/>
																	  </uix:contents>
																	</uix:messageChoice>
																  </uix:contents>
																</uix:cellFormat>
																
																<uix:spacer height="5" width="5"/>
																<uix:cellFormat>
																  <uix:contents>
																	<uix:submitButton textBinding="GO@MasterGrpMsgs" name="event" value="myGo" shortDescBinding="GO@MasterGrpMsgs"/>
																  </uix:contents>
																</uix:cellFormat>
															  </uix:contents>
															</uix:rowLayout>
														  </uix:contents>
														</uix:cellFormat>
													  </uix:contents>
													</uix:rowLayout>
											
									  </uix:tableActions>
									</uix:table>
								</uix:dataScope>
								</uix:cellFormat>
							 </uix:rowLayout>
						</uix:tableLayout>
							<uix:tip>
						<uix:styledText textBinding="COMPARE_TIP@TemplateMsgs" styleClass="OraInfoText"/>
               							</uix:tip>
                     </uix:contents>                                            
					 <uix:pageStatus>
				              <uix:formattedText textBinding="TEMP_LIST_INST@TemplateMsgs" styleClass="OraInstructionText"/>
				       </uix:pageStatus>
	 	     </uix:pageLayout>          
		</uix:contents>
		</uix:form>
		</uix:body>
       </uix:contents>
      </uix:document>  

</uix:renderingContext>

<!--uix:option text="ScriptGeneration" value="SCRIPT_GEN"/-->
																	
