<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
	
	<uix:document>
	  <%@ include file="/oemTitle.jspf"%>   
		  <uix:contents>
				<uix:body>
				<uix:form name="addNewObject" method="post">
				<uix:formValue name="pageName" value="/database/dist/advRepl/template/addNewObject"/>
				<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

				  <uix:contents>
                    <uix:pageLayout styleClass="OraInstructionText" titleBinding="header@servletRequest">
						<%@ include file="/oemGlobal.jspf"%>
						
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
					  <uix:contents>

							<uix:tableLayout cellSpacing="5">
							<uix:rowLayout>
									<uix:cellFormat>
                                		<uix:messageStyledText styleClass="OraInstructionText" required="yes" 
                                                textBinding="NAME@MasterGrpMsgs" labeledNodeId ="nameOfObj"/>
									</uix:cellFormat>
									<uix:cellFormat>
										<uix:messageTextInput name="newObjName" id="nameOfObj" textBinding="newObjName@defaultBean@servletRequest"
										shortDescBinding="NAME@MasterGrpMsgs"/>
									</uix:cellFormat>
								</uix:rowLayout>
								<uix:rowLayout>
									<uix:cellFormat>
										<uix:styledText textBinding="TYPE@MasterGrpMsgs" styleClass="oraInstructionText" labeledNodeId ="typeOfObj"/>
									</uix:cellFormat>
									<uix:cellFormat>
		                                   <oem:choice 
                                         name="newObjType" id="typeOfObj"
                                         optionsBinding="objTypes@defaultBean@servletRequest"
	                                     selectedValueBinding="newObjType@defaultBean@servletRequest"/>
										 <%--
										<uix:messageChoice name="objType">
											<uix:option text="Table" value="table"/>
											<uix:option text="View" value="view"/>
											<uix:option text="Index"/>
											<uix:option text="Sequence"/>
											<uix:option text="Trigger"/>
											<uix:option text="Synonym"/>
											<uix:option text="Procedure"/>
											<uix:option text="Function"/>
											<uix:option text="Package"/>
											<uix:option text="Package Body"/>
											<uix:option text="Materialized View"/>
										</uix:messageChoice>
										--%>
									</uix:cellFormat>
								</uix:rowLayout>
								<uix:rowLayout/>
								<uix:rowLayout>
									<uix:cellFormat vAlign="top">
                                        <uix:messageStyledText styleClass="OraInstructionText" required="yes" 
                                            textBinding="DDL_TEXT@MasterGrpMsgs" />
									</uix:cellFormat>
									<uix:cellFormat>
										<uix:messageTextInput name="newObjDDL" textBinding="newObjDDL@defaultBean@servletRequest" rows="5" columns="80" shortDescBinding="DDL_TEXT@MasterGrpMsgs"/>
									</uix:cellFormat>
								</uix:rowLayout>

							</uix:tableLayout>
                      </uix:contents>
                     <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                           <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel" shortDescBinding="CANCEL@ARSetupMsgs"/>
                            <uix:submitButton textBinding="OK@ARSetupMsgs" name="event" value="OK_addNewObject" shortDescBinding="OK@ARSetupMsgs"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                     
					  <uix:pageStatus>
						<uix:styledText textBinding="ADD_NEW_OBJ_INST@ARSetupMsgs" styleClass="OraInstructionText"/>
					  </uix:pageStatus>

						<uix:location>
                           <uix:train value="1">
                              <uix:contents>
								<uix:link textBinding="GEN@MasterGrpMsgs"/>
                                <uix:link textBinding="SUBSETTING@ARSetupMsgs" disabled="true"/>
                                <uix:link textBinding="TEMP_PARAMS@ARSetupMsgs" disabled="true"/>
								<uix:link textBinding="SCHED_EM_JOB@ARSetupMsgs"  disabled="true"/>
								<uix:link textBinding="REVIEW@ARSetupMsgs"  disabled="true"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>

					</uix:pageLayout>
                  
				  </uix:contents>
                </uix:form>
					</uix:body>
              </uix:contents>

		</uix:document>

</uix:renderingContext>
